/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.assignor.AbstractUniformAssignmentBuilder;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.server.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralUniformAssignmentBuilder
extends AbstractUniformAssignmentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralUniformAssignmentBuilder.class);
    private final Map<String, AssignmentMemberSpec> members;
    private final SubscribedTopicDescriber subscribedTopicDescriber;
    private final Set<Uuid> subscribedTopicIds;
    private final Map<Uuid, List<String>> membersPerTopic;
    private final Map<String, MemberAssignment> targetAssignment;
    private final AbstractUniformAssignmentBuilder.RackInfo rackInfo;
    private final Set<TopicIdPartition> unassignedPartitions;
    private final Set<TopicIdPartition> assignedStickyPartitions;
    private final AssignmentManager assignmentManager;
    private final TreeSet<String> sortedMembersByAssignmentSize;
    private final Map<TopicIdPartition, String> currentPartitionOwners;
    private final Map<TopicIdPartition, String> partitionOwnerInTargetAssignment;
    private final PartitionMovements partitionMovements;

    public GeneralUniformAssignmentBuilder(AssignmentSpec assignmentSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        this.members = assignmentSpec.members();
        this.subscribedTopicDescriber = subscribedTopicDescriber;
        this.subscribedTopicIds = new HashSet<Uuid>();
        this.membersPerTopic = new HashMap<Uuid, List<String>>();
        this.targetAssignment = new HashMap<String, MemberAssignment>();
        this.members.forEach((memberId, memberMetadata) -> memberMetadata.subscribedTopicIds().forEach(topicId -> {
            int partitionCount = subscribedTopicDescriber.numPartitions((Uuid)topicId);
            if (partitionCount == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + topicId + " which doesn't exist in the topic metadata.");
            }
            this.subscribedTopicIds.add((Uuid)topicId);
            this.membersPerTopic.computeIfAbsent((Uuid)topicId, k -> new ArrayList()).add(memberId);
            this.targetAssignment.put((String)memberId, new MemberAssignment(new HashMap<Uuid, Set<Integer>>()));
        }));
        this.rackInfo = new AbstractUniformAssignmentBuilder.RackInfo(assignmentSpec, subscribedTopicDescriber, this.subscribedTopicIds);
        this.unassignedPartitions = new HashSet<TopicIdPartition>(GeneralUniformAssignmentBuilder.topicIdPartitions(this.subscribedTopicIds, subscribedTopicDescriber));
        this.assignedStickyPartitions = new HashSet<TopicIdPartition>();
        this.assignmentManager = new AssignmentManager(this.members, this.subscribedTopicDescriber);
        this.sortedMembersByAssignmentSize = this.assignmentManager.sortMembersByAssignmentSize(this.members.keySet());
        this.currentPartitionOwners = new HashMap<TopicIdPartition, String>();
        this.partitionOwnerInTargetAssignment = new HashMap<TopicIdPartition, String>();
        this.partitionMovements = new PartitionMovements();
    }

    @Override
    protected GroupAssignment buildAssignment() {
        if (this.subscribedTopicIds.isEmpty()) {
            LOG.info("The subscription list is empty, returning an empty assignment");
            return new GroupAssignment(Collections.emptyMap());
        }
        this.assignStickyPartitions();
        if (this.rackInfo.useRackStrategy) {
            this.rackAwarePartitionAssignment();
        }
        this.unassignedPartitionsAssignment();
        this.balance();
        return new GroupAssignment(this.targetAssignment);
    }

    private List<TopicIdPartition> sortTopicIdPartitions(Collection<TopicIdPartition> topicIdPartitions) {
        Comparator<TopicIdPartition> comparator = Comparator.comparingDouble(topicIdPartition -> {
            int totalPartitions = this.subscribedTopicDescriber.numPartitions(topicIdPartition.topicId());
            int totalSubscribers = this.membersPerTopic.get(topicIdPartition.topicId()).size();
            return (double)totalPartitions / (double)totalSubscribers;
        }).reversed().thenComparingInt(topicIdPartition -> this.membersPerTopic.get(topicIdPartition.topicId()).size()).thenComparingInt(TopicIdPartition::partitionId);
        return topicIdPartitions.stream().sorted(comparator).collect(Collectors.toList());
    }

    private void assignStickyPartitions() {
        this.members.forEach((memberId, assignmentMemberSpec) -> assignmentMemberSpec.assignedPartitions().forEach((topicId, currentAssignment) -> {
            if (assignmentMemberSpec.subscribedTopicIds().contains(topicId)) {
                currentAssignment.forEach(partition -> {
                    TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, partition.intValue());
                    if (this.rackInfo.useRackStrategy && this.rackInfo.racksMismatch((String)memberId, topicIdPartition)) {
                        this.currentPartitionOwners.put(topicIdPartition, (String)memberId);
                    } else {
                        this.assignmentManager.addPartitionToTargetAssignment(topicIdPartition, memberId);
                        this.assignedStickyPartitions.add(topicIdPartition);
                    }
                });
            } else {
                LOG.debug("The topic " + topicId + " is no longer present in the subscribed topics list");
            }
        }));
    }

    private void rackAwarePartitionAssignment() {
        List<TopicIdPartition> sortedPartitions = this.rackInfo.sortPartitionsByRackMembers(this.unassignedPartitions);
        sortedPartitions.forEach(partition -> {
            List<String> sortedMembersByAssignmentSize = this.rackInfo.getSortedMembersWithMatchingRack((TopicIdPartition)partition, this.targetAssignment);
            for (String memberId : sortedMembersByAssignmentSize) {
                if (this.assignmentManager.maybeAssignPartitionToMember(partition, memberId)) break;
            }
        });
    }

    private void unassignedPartitionsAssignment() {
        List<TopicIdPartition> sortedPartitions = this.sortTopicIdPartitions(this.unassignedPartitions);
        for (TopicIdPartition partition : sortedPartitions) {
            String member;
            String prevOwner;
            if (this.rackInfo.useRackStrategy && this.currentPartitionOwners.containsKey(partition) && this.assignmentManager.maybeAssignPartitionToMember(partition, prevOwner = this.currentPartitionOwners.get(partition))) continue;
            TreeSet sortedMembers = this.assignmentManager.sortMembersByAssignmentSize(this.membersPerTopic.get(partition.topicId()));
            Iterator iterator = sortedMembers.iterator();
            while (iterator.hasNext() && !this.assignmentManager.maybeAssignPartitionToMember(partition, member = (String)iterator.next())) {
            }
        }
    }

    private boolean canTopicParticipateInReassignment(Uuid topicId) {
        return this.membersPerTopic.get(topicId).size() >= 2;
    }

    private boolean canMemberParticipateInReassignment(String memberId) {
        int maxAssignmentSize;
        Set<Uuid> assignedTopicIds = this.targetAssignment.get(memberId).targetPartitions().keySet();
        int currentAssignmentSize = this.assignmentManager.targetAssignmentSize(memberId);
        if (currentAssignmentSize > (maxAssignmentSize = this.assignmentManager.maxAssignmentSize(memberId))) {
            LOG.error("The member {} is assigned more partitions than the maximum possible.", (Object)memberId);
        }
        if (currentAssignmentSize < maxAssignmentSize) {
            return true;
        }
        for (Uuid topicId : assignedTopicIds) {
            if (!this.canTopicParticipateInReassignment(topicId)) continue;
            return true;
        }
        return false;
    }

    private boolean isBalanced() {
        int max;
        int min = this.assignmentManager.targetAssignmentSize(this.sortedMembersByAssignmentSize.first());
        if (min >= (max = this.assignmentManager.targetAssignmentSize(this.sortedMembersByAssignmentSize.last())) - 1) {
            return true;
        }
        for (String member : this.sortedMembersByAssignmentSize) {
            int maxAssignmentSize;
            int memberPartitionCount = this.assignmentManager.targetAssignmentSize(member);
            if (memberPartitionCount == (maxAssignmentSize = this.assignmentManager.maxAssignmentSize(member))) continue;
            for (Uuid topicId : this.members.get(member).subscribedTopicIds()) {
                Set<Integer> assignedPartitions = this.targetAssignment.get(member).targetPartitions().get(topicId);
                for (int i = 0; i < this.subscribedTopicDescriber.numPartitions(topicId); ++i) {
                    String otherMember;
                    int otherMemberPartitionCount;
                    TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, i);
                    if (assignedPartitions != null && assignedPartitions.contains(i) || memberPartitionCount + 1 >= (otherMemberPartitionCount = this.assignmentManager.targetAssignmentSize(otherMember = this.partitionOwnerInTargetAssignment.get(topicIdPartition)))) continue;
                    LOG.debug("{} can be moved from member {} to member {} for a more balanced assignment.", new Object[]{topicIdPartition, otherMember, member});
                    return false;
                }
            }
        }
        return true;
    }

    private void balance() {
        if (!this.unassignedPartitions.isEmpty()) {
            throw new PartitionAssignorException("Some partitions were left unassigned");
        }
        this.unassignedPartitions.addAll(GeneralUniformAssignmentBuilder.topicIdPartitions(this.subscribedTopicIds, this.subscribedTopicDescriber));
        HashSet<TopicIdPartition> fixedPartitions = new HashSet<TopicIdPartition>();
        for (Uuid topicId : this.subscribedTopicIds) {
            if (this.canTopicParticipateInReassignment(topicId)) continue;
            for (int i = 0; i < this.subscribedTopicDescriber.numPartitions(topicId); ++i) {
                fixedPartitions.add(new TopicIdPartition(topicId, i));
            }
        }
        this.unassignedPartitions.removeAll(fixedPartitions);
        for (String member : this.members.keySet()) {
            if (this.canMemberParticipateInReassignment(member)) continue;
            this.sortedMembersByAssignmentSize.remove(member);
        }
        if (!this.unassignedPartitions.isEmpty()) {
            this.performReassignments();
        }
    }

    private void performReassignments() {
        boolean modified;
        do {
            modified = false;
            boolean reassignmentOccurred = false;
            List<TopicIdPartition> reassignablePartitions = this.sortTopicIdPartitions(this.unassignedPartitions);
            block1: for (TopicIdPartition reassignablePartition : reassignablePartitions) {
                if (reassignmentOccurred && this.isBalanced()) {
                    return;
                }
                reassignmentOccurred = false;
                if (this.membersPerTopic.get(reassignablePartition.topicId()).size() <= 1) {
                    throw new PartitionAssignorException(String.format("Expected more than one potential member for topicIdPartition '%s'", reassignablePartition));
                }
                String currentTargetOwner = this.partitionOwnerInTargetAssignment.get(reassignablePartition);
                if (currentTargetOwner == null) {
                    throw new PartitionAssignorException(String.format("Expected topicIdPartition '%s' to be assigned to a member", reassignablePartition));
                }
                boolean foundMatchingRackMember = false;
                if (this.rackInfo.useRackStrategy) {
                    String memberRack = this.rackInfo.memberRacks.get(currentTargetOwner);
                    Set<String> partitionRacks = this.rackInfo.partitionRacks.get(reassignablePartition);
                    if (partitionRacks.contains(memberRack)) {
                        for (String otherMember : this.rackInfo.getSortedMembersWithMatchingRack(reassignablePartition, this.targetAssignment)) {
                            String otherMemberRack;
                            if (!this.sortedMembersByAssignmentSize.contains(otherMember) || !this.membersPerTopic.containsKey(reassignablePartition.topicId()) || (otherMemberRack = this.rackInfo.memberRacks.get(otherMember)) == null || !partitionRacks.contains(otherMemberRack) || this.assignmentManager.targetAssignmentSize(currentTargetOwner) <= this.assignmentManager.targetAssignmentSize(otherMember) + 1) continue;
                            this.reassignPartition(reassignablePartition, otherMember);
                            modified = true;
                            reassignmentOccurred = true;
                            foundMatchingRackMember = true;
                            break;
                        }
                    }
                }
                if (foundMatchingRackMember) continue;
                boolean isPartitionSticky = this.assignedStickyPartitions.contains(reassignablePartition);
                boolean isCurrentOwnerKnown = this.currentPartitionOwners.containsKey(reassignablePartition);
                if (this.rackInfo.useRackStrategy && !isPartitionSticky && isCurrentOwnerKnown) {
                    int currentOwnerAssignmentSize;
                    String currentOwner = this.currentPartitionOwners.get(reassignablePartition);
                    int currentMemberAssignmentSize = this.assignmentManager.targetAssignmentSize(currentTargetOwner);
                    if (currentMemberAssignmentSize > (currentOwnerAssignmentSize = this.assignmentManager.targetAssignmentSize(currentOwner)) + 1) {
                        this.reassignPartition(reassignablePartition, currentOwner);
                        modified = true;
                        reassignmentOccurred = true;
                    }
                }
                if (reassignmentOccurred) continue;
                for (String otherMember : this.membersPerTopic.get(reassignablePartition.topicId())) {
                    if (this.assignmentManager.targetAssignmentSize(currentTargetOwner) <= this.assignmentManager.targetAssignmentSize(otherMember) + 1) continue;
                    this.reassignPartition(reassignablePartition);
                    modified = true;
                    reassignmentOccurred = true;
                    continue block1;
                }
            }
        } while (modified);
    }

    private void reassignPartition(TopicIdPartition partition) {
        String newOwner = null;
        for (String anotherMember : this.sortedMembersByAssignmentSize) {
            if (!this.members.get(anotherMember).subscribedTopicIds().contains(partition.topicId())) continue;
            newOwner = anotherMember;
            break;
        }
        if (newOwner == null) {
            throw new PartitionAssignorException("No suitable new owner was found for the partition" + partition);
        }
        this.reassignPartition(partition, newOwner);
    }

    private void reassignPartition(TopicIdPartition partition, String newMember) {
        String member = this.partitionOwnerInTargetAssignment.get(partition);
        TopicIdPartition partitionToBeMoved = this.partitionMovements.computeActualPartitionToBeMoved(partition, member, newMember);
        this.processPartitionMovement(partitionToBeMoved, newMember);
    }

    private void processPartitionMovement(TopicIdPartition topicIdPartition, String newMember) {
        String oldMember = this.partitionOwnerInTargetAssignment.get(topicIdPartition);
        this.partitionMovements.movePartition(topicIdPartition, oldMember, newMember);
        this.assignmentManager.removePartitionFromTargetAssignment(topicIdPartition, oldMember);
        this.assignmentManager.addPartitionToTargetAssignment(topicIdPartition, newMember);
    }

    private class AssignmentManager {
        private final Map<String, MemberAssignmentData> membersWithAssignmentSizes = new HashMap<String, MemberAssignmentData>();

        public AssignmentManager(Map<String, AssignmentMemberSpec> members, SubscribedTopicDescriber subscribedTopicDescriber) {
            members.forEach((memberId, member) -> {
                int maxSize = member.subscribedTopicIds().stream().mapToInt(subscribedTopicDescriber::numPartitions).sum();
                MemberAssignmentData memberAssignmentData = this.membersWithAssignmentSizes.computeIfAbsent((String)memberId, x$0 -> new MemberAssignmentData((String)x$0));
                memberAssignmentData.maxAssignmentSize = maxSize;
                memberAssignmentData.currentAssignmentSize = 0;
            });
        }

        private int targetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return 0;
            }
            return memberData.currentAssignmentSize;
        }

        private int maxAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return 0;
            }
            return memberData.maxAssignmentSize;
        }

        private boolean isMemberAtMaxCapacity(String memberId) {
            return this.targetAssignmentSize(memberId) >= this.maxAssignmentSize(memberId);
        }

        private void incrementTargetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return;
            }
            ++memberData.currentAssignmentSize;
        }

        private void decrementTargetAssignmentSize(String memberId) {
            MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
            if (memberData == null) {
                LOG.warn("Member Id {} not found", (Object)memberId);
                return;
            }
            if (memberData.currentAssignmentSize > 0) {
                --memberData.currentAssignmentSize;
            }
        }

        private boolean maybeAssignPartitionToMember(TopicIdPartition topicIdPartition, String memberId) {
            if (!((AssignmentMemberSpec)GeneralUniformAssignmentBuilder.this.members.get(memberId)).subscribedTopicIds().contains(topicIdPartition.topicId())) {
                return false;
            }
            if (this.isMemberAtMaxCapacity(memberId)) {
                return false;
            }
            this.addPartitionToTargetAssignment(topicIdPartition, memberId);
            return true;
        }

        private void addPartitionToTargetAssignment(TopicIdPartition topicIdPartition, String memberId) {
            AbstractUniformAssignmentBuilder.addPartitionToAssignment(GeneralUniformAssignmentBuilder.this.targetAssignment, memberId, topicIdPartition.topicId(), topicIdPartition.partitionId());
            GeneralUniformAssignmentBuilder.this.partitionOwnerInTargetAssignment.put(topicIdPartition, memberId);
            GeneralUniformAssignmentBuilder.this.sortedMembersByAssignmentSize.remove(memberId);
            GeneralUniformAssignmentBuilder.this.assignmentManager.incrementTargetAssignmentSize(memberId);
            if (!this.isMemberAtMaxCapacity(memberId)) {
                GeneralUniformAssignmentBuilder.this.sortedMembersByAssignmentSize.add(memberId);
            }
            GeneralUniformAssignmentBuilder.this.unassignedPartitions.remove(topicIdPartition);
        }

        private void removePartitionFromTargetAssignment(TopicIdPartition topicIdPartition, String memberId) {
            Map<Uuid, Set<Integer>> targetPartitionsMap = ((MemberAssignment)GeneralUniformAssignmentBuilder.this.targetAssignment.get(memberId)).targetPartitions();
            Set<Integer> partitionsSet = targetPartitionsMap.get(topicIdPartition.topicId());
            if (partitionsSet != null) {
                partitionsSet.remove(topicIdPartition.partitionId());
                if (partitionsSet.isEmpty()) {
                    targetPartitionsMap.remove(topicIdPartition.topicId());
                }
            }
            GeneralUniformAssignmentBuilder.this.partitionOwnerInTargetAssignment.remove(topicIdPartition, memberId);
            GeneralUniformAssignmentBuilder.this.sortedMembersByAssignmentSize.remove(memberId);
            GeneralUniformAssignmentBuilder.this.assignmentManager.decrementTargetAssignmentSize(memberId);
            if (!this.isMemberAtMaxCapacity(memberId)) {
                GeneralUniformAssignmentBuilder.this.sortedMembersByAssignmentSize.add(memberId);
            }
        }

        private TreeSet<String> sortMembersByAssignmentSize(Collection<String> memberIds) {
            Comparator<String> comparator = Comparator.comparingInt(memberId -> this.membersWithAssignmentSizes.get((Object)memberId).currentAssignmentSize).thenComparing(memberId -> memberId);
            return memberIds.stream().filter(memberId -> {
                MemberAssignmentData memberData = this.membersWithAssignmentSizes.get(memberId);
                return memberData.currentAssignmentSize < memberData.maxAssignmentSize;
            }).collect(Collectors.toCollection(() -> new TreeSet(comparator)));
        }

        private class MemberAssignmentData {
            final String memberId;
            int currentAssignmentSize = 0;
            int maxAssignmentSize;

            MemberAssignmentData(String memberId) {
                this.memberId = memberId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MemberAssignmentData that = (MemberAssignmentData)o;
                return this.memberId.equals(that.memberId);
            }

            public int hashCode() {
                return Objects.hash(this.memberId);
            }

            public String toString() {
                return "MemberAssignmentData(memberId='" + this.memberId + '\'' + ", currentAssignmentSize=" + this.currentAssignmentSize + ", maxAssignmentSize=" + this.maxAssignmentSize + ')';
            }
        }
    }

    private static class PartitionMovements {
        private final Map<Uuid, Map<MemberPair, Set<TopicIdPartition>>> partitionMovementsByTopic = new HashMap<Uuid, Map<MemberPair, Set<TopicIdPartition>>>();
        private final Map<TopicIdPartition, MemberPair> partitionMovementsByPartition = new HashMap<TopicIdPartition, MemberPair>();

        private PartitionMovements() {
        }

        private MemberPair removeMovementRecordOfPartition(TopicIdPartition partition) {
            MemberPair pair = this.partitionMovementsByPartition.remove(partition);
            Uuid topic = partition.topicId();
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic);
            partitionMovementsForThisTopic.get(pair).remove(partition);
            if (partitionMovementsForThisTopic.get(pair).isEmpty()) {
                partitionMovementsForThisTopic.remove(pair);
            }
            if (this.partitionMovementsByTopic.get(topic).isEmpty()) {
                this.partitionMovementsByTopic.remove(topic);
            }
            return pair;
        }

        private void addPartitionMovementRecord(TopicIdPartition partition, MemberPair pair) {
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic;
            this.partitionMovementsByPartition.put(partition, pair);
            Uuid topic = partition.topicId();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                this.partitionMovementsByTopic.put(topic, new HashMap());
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(pair)) {
                partitionMovementsForThisTopic.put(pair, new HashSet());
            }
            partitionMovementsForThisTopic.get(pair).add(partition);
        }

        private void movePartition(TopicIdPartition partition, String oldOwner, String newOwner) {
            MemberPair pair = new MemberPair(oldOwner, newOwner);
            if (this.partitionMovementsByPartition.containsKey(partition)) {
                MemberPair existingPair = this.removeMovementRecordOfPartition(partition);
                if (existingPair.dstMemberId.equals(oldOwner)) {
                    throw new PartitionAssignorException("Mismatch in partition movement record with respect to partition ownership during a rebalance");
                }
                if (!existingPair.srcMemberId.equals(newOwner)) {
                    this.addPartitionMovementRecord(partition, new MemberPair(existingPair.srcMemberId, newOwner));
                }
            } else {
                this.addPartitionMovementRecord(partition, pair);
            }
        }

        private TopicIdPartition computeActualPartitionToBeMoved(TopicIdPartition partition, String oldOwner, String newOwner) {
            MemberPair reversePair;
            Map<MemberPair, Set<TopicIdPartition>> partitionMovementsForThisTopic;
            Uuid topic = partition.topicId();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                return partition;
            }
            if (this.partitionMovementsByPartition.containsKey(partition)) {
                String expectedOldOwner = this.partitionMovementsByPartition.get(partition).dstMemberId;
                if (!oldOwner.equals(expectedOldOwner)) {
                    throw new PartitionAssignorException("Old owner does not match expected value for partition: " + partition);
                }
                oldOwner = this.partitionMovementsByPartition.get(partition).srcMemberId;
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(reversePair = new MemberPair(newOwner, oldOwner))) {
                return partition;
            }
            return partitionMovementsForThisTopic.get(reversePair).iterator().next();
        }
    }

    private static class MemberPair {
        private final String srcMemberId;
        private final String dstMemberId;

        MemberPair(String srcMemberId, String dstMemberId) {
            this.srcMemberId = srcMemberId;
            this.dstMemberId = dstMemberId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.srcMemberId == null ? 0 : this.srcMemberId.hashCode());
            result = 31 * result + (this.dstMemberId == null ? 0 : this.dstMemberId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            MemberPair otherPair = (MemberPair)obj;
            return this.srcMemberId.equals(otherPair.srcMemberId) && this.dstMemberId.equals(otherPair.dstMemberId);
        }

        public String toString() {
            return "MemberPair(srcMemberId='" + this.srcMemberId + '\'' + ", dstMemberId='" + this.dstMemberId + '\'' + ')';
        }
    }
}

