/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.builder;

import jakarta.el.ValueExpression;
import jakarta.faces.flow.builder.FlowCallBuilder;
import org.apache.myfaces.flow.FlowCallNodeImpl;
import org.apache.myfaces.flow.FlowImpl;
import org.apache.myfaces.flow.ParameterImpl;
import org.apache.myfaces.flow.builder.FlowBuilderImpl;
import org.apache.myfaces.view.facelets.el.ELText;

public class FlowCallBuilderImpl
extends FlowCallBuilder {
    private FlowBuilderImpl flowBuilder;
    private FlowImpl facesFlow;
    private FlowCallNodeImpl flowCallNode;

    public FlowCallBuilderImpl(FlowBuilderImpl flowBuilder, FlowImpl facesFlow, String flowCallNodeId) {
        this.flowBuilder = flowBuilder;
        this.facesFlow = facesFlow;
        this.flowCallNode = new FlowCallNodeImpl(flowCallNodeId);
        this.facesFlow.putFlowCall(flowCallNodeId, this.flowCallNode);
    }

    @Override
    public FlowCallBuilder flowReference(String flowDocumentId, String flowId) {
        if (ELText.isLiteral(flowDocumentId)) {
            this.flowCallNode.setCalledFlowDocumentId(flowDocumentId);
        } else {
            this.flowCallNode.setCalledFlowDocumentId(this.flowBuilder.createValueExpression(flowDocumentId));
        }
        if (ELText.isLiteral(flowId)) {
            this.flowCallNode.setCalledFlowId(flowId);
        } else {
            this.flowCallNode.setCalledFlowId(this.flowBuilder.createValueExpression(flowId));
        }
        return this;
    }

    @Override
    public FlowCallBuilder outboundParameter(String name, ValueExpression value) {
        this.flowCallNode.putOutboundParameter(name, new ParameterImpl(name, value));
        return this;
    }

    @Override
    public FlowCallBuilder outboundParameter(String name, String value) {
        this.flowCallNode.putOutboundParameter(name, new ParameterImpl(name, this.flowBuilder.createValueExpression(value)));
        return this;
    }

    @Override
    public FlowCallBuilder markAsStartNode() {
        this.facesFlow.setStartNodeId(this.flowCallNode.getId());
        return this;
    }
}

