/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntKeyValueIterator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBTcommon;

public class Int2IntRBT
extends IntArrayRBTcommon {
    protected int[] values;
    private int prevValue;
    private int lastNodeGotten;

    private int getValue(int node) {
        return this.values[node];
    }

    public Int2IntRBT() {
        super(8);
    }

    public Int2IntRBT(int initialSize) {
        super(initialSize);
    }

    @Override
    protected void setupArrays() {
        super.setupArrays();
        this.values = new int[this.initialSize];
    }

    public Int2IntRBT copy() {
        Int2IntRBT c = new Int2IntRBT();
        c.klrp = (int[])this.klrp.clone();
        c.klrp1 = this.klrp1 != null ? (int[])this.klrp1.clone() : null;
        c.klrp2 = this.klrp2 != null ? (int[])this.klrp2.clone() : null;
        c.klrp3 = this.klrp3 != null ? (int[])this.klrp3.clone() : null;
        c.color = (boolean[])this.color.clone();
        c.values = (int[])this.values.clone();
        c.root = this.root;
        c.greatestNode = this.greatestNode;
        c.next = this.next;
        c.size = this.size;
        return c;
    }

    public void clear() {
        this.flush();
    }

    @Override
    public void flush() {
        super.flush();
        this.lastNodeGotten = 0;
    }

    @Override
    protected void ensureCapacityKlrp(int requiredSize) {
        super.ensureCapacityKlrp(requiredSize);
        this.values = this.ensureArrayCapacity(this.values, requiredSize);
    }

    private int treeInsert(int k, int v) {
        if (this.greatestNode != 0 && this.getKeyForNode(this.greatestNode) < k) {
            int y = this.greatestNode;
            int z = this.newNode(k);
            this.values[z] = v;
            this.greatestNode = z;
            this.setRight(y, z);
            this.setParent(z, y);
            return z;
        }
        int x = this.root;
        int y = 0;
        while (x != 0) {
            y = x;
            int xKey = this.getKeyForNode(x);
            if (k == xKey) {
                this.prevValue = this.values[x];
                this.values[x] = v;
                return -x;
            }
            x = k < xKey ? this.getLeft(x) : this.getRight(x);
        }
        int z = this.newNode(k);
        this.values[z] = v;
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
            this.setParent(z, 0);
        } else {
            this.setParent(z, y);
            if (k < this.getKeyForNode(y)) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    public int get(int k) {
        int node = this.findKey(k);
        if (node == 0) {
            return 0;
        }
        return this.values[node];
    }

    public int getMostlyClose(int k) {
        int node = this.findKeyFast(k);
        if (node == 0) {
            return 0;
        }
        return this.values[node];
    }

    public int put(int k, int v) {
        if (this.root == 0) {
            int x = this.newNode(k);
            this.values[x] = v;
            this.setAsRoot(x);
            this.color[this.root] = false;
            this.greatestNode = x;
            return 0;
        }
        int x = this.treeInsert(k, v);
        if (x < 0) {
            return this.prevValue;
        }
        this.color[x] = true;
        while (x != this.root && this.color[this.getParent(x)]) {
            int parent2_parent2_x;
            int parent2_x;
            int y;
            int parent_parent_x;
            int parent_x = this.getParent(x);
            if (parent_x == this.getLeft(parent_parent_x = this.getParent(parent_x))) {
                y = this.getRight(parent_parent_x);
                if (this.color[y]) {
                    this.color[parent_x] = false;
                    this.color[y] = false;
                    this.color[parent_parent_x] = true;
                    x = parent_parent_x;
                    continue;
                }
                if (x == this.getRight(parent_x)) {
                    x = parent_x;
                    this.leftRotate(x);
                }
                parent2_x = this.getParent(x);
                this.color[parent2_x] = false;
                parent2_parent2_x = this.getParent(parent2_x);
                this.color[parent2_parent2_x] = true;
                this.rightRotate(parent2_parent2_x);
                continue;
            }
            y = this.getLeft(parent_parent_x);
            if (this.color[y]) {
                this.color[parent_x] = false;
                this.color[y] = false;
                this.color[parent_parent_x] = true;
                x = parent_parent_x;
                continue;
            }
            if (x == this.getLeft(parent_x)) {
                x = parent_x;
                this.rightRotate(x);
            }
            parent2_x = this.getParent(x);
            this.color[parent2_x] = false;
            parent2_parent2_x = this.getParent(parent2_x);
            this.color[parent2_parent2_x] = true;
            this.leftRotate(parent2_parent2_x);
        }
        this.color[this.root] = false;
        return 0;
    }

    protected int findKeyFast(int k) {
        int node;
        if (this.lastNodeGotten == 0) {
            node = this.findKey(k);
        } else {
            int distanceToLast;
            int distanceToTop = Math.abs(k - this.getKeyForNode(this.root));
            int n = node = distanceToTop < (distanceToLast = Math.abs(k - this.getKeyForNode(this.lastNodeGotten))) ? this.findKey(k) : this.findKeyFromLast(k);
        }
        if (node != 0) {
            this.lastNodeGotten = node;
        }
        return node;
    }

    private int findKeyFromLast(int k) {
        int node = this.lastNodeGotten;
        int keyNode = this.getKeyForNode(node);
        if (k < keyNode) {
            int prevNode;
            do {
                prevNode = node;
            } while ((node = this.getParent(node)) != 0 && k < (keyNode = this.getKeyForNode(node)));
            if (keyNode == k) {
                return node;
            }
            return this.findKeyDown(k, prevNode);
        }
        if (k > keyNode) {
            int prevNode;
            do {
                prevNode = node;
            } while ((node = this.getParent(node)) != 0 && k > (keyNode = this.getKeyForNode(node)));
            if (keyNode == k) {
                return node;
            }
            return this.findKeyDown(k, prevNode);
        }
        return node;
    }

    public IntListIterator keyIterator() {
        return new KeyIterator();
    }

    public IntListIterator keyIterator(int aKey) {
        KeyIterator it = new KeyIterator();
        it.currentNode = this.findKey(aKey);
        return it;
    }

    public IntKeyValueIterator keyValueIterator() {
        return new KeyValueIterator();
    }

    public IntKeyValueIterator keyValueIterator(int aKey) {
        KeyValueIterator it = new KeyValueIterator();
        it.currentNode = this.findKey(aKey);
        return it;
    }

    private class KeyIterator
    implements IntListIterator {
        private int currentNode = 0;

        private KeyIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.currentNode != Int2IntRBT.this.greatestNode;
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentNode = this.currentNode == 0 ? Int2IntRBT.this.getFirstNode() : Int2IntRBT.this.nextNode(this.currentNode);
            return Int2IntRBT.this.getKeyForNode(this.currentNode);
        }

        @Override
        public boolean hasPrevious() {
            return this.currentNode != 0;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int currentKey = Int2IntRBT.this.getKeyForNode(this.currentNode);
            this.currentNode = this.currentNode == Int2IntRBT.this.getFirstNode() ? 0 : Int2IntRBT.this.previousNode(this.currentNode);
            return currentKey;
        }

        @Override
        public void moveToEnd() {
            this.currentNode = Int2IntRBT.this.greatestNode;
        }

        @Override
        public void moveToStart() {
            this.currentNode = 0;
        }
    }

    private class KeyValueIterator
    implements IntKeyValueIterator {
        private int currentNode;

        private KeyValueIterator() {
            this.moveToFirst();
        }

        @Override
        public void dec() {
            this.currentNode = Int2IntRBT.this.previousNode(this.currentNode);
        }

        @Override
        public int get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return Int2IntRBT.this.getKeyForNode(this.currentNode);
        }

        @Override
        public int getValue() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return Int2IntRBT.this.getValue(this.currentNode);
        }

        @Override
        public void inc() {
            this.currentNode = Int2IntRBT.this.nextNode(this.currentNode);
        }

        @Override
        public boolean isValid() {
            return this.currentNode != 0;
        }

        @Override
        public void moveToFirst() {
            this.currentNode = Int2IntRBT.this.getFirstNode();
        }

        @Override
        public void moveToLast() {
            this.currentNode = Int2IntRBT.this.greatestNode;
        }

        @Override
        public Object copy() {
            KeyValueIterator it = new KeyValueIterator();
            it.currentNode = this.currentNode;
            return it;
        }

        @Override
        public void moveTo(int i) {
            this.currentNode = Int2IntRBT.this.findInsertionPointNoDups(i);
        }
    }
}

