/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.commons.collections.ControlledArrayList;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.PredicateUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.http.part.BasicPartIterator;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.http.part.PartBeanMeta;
import org.apache.juneau.http.part.PartIterator;
import org.apache.juneau.svl.VarResolver;

public class PartList
extends ControlledArrayList<NameValuePair> {
    private static final long serialVersionUID = 1L;
    private VarResolver varResolver;
    boolean caseInsensitive;

    public static PartList create() {
        return new PartList();
    }

    public static PartList of(List<NameValuePair> parts) {
        return new PartList().append(parts);
    }

    public static PartList of(NameValuePair ... parts) {
        return new PartList().append(parts);
    }

    public static PartList ofPairs(String ... pairs) {
        PartList x = new PartList();
        if (pairs == null) {
            pairs = new String[]{};
        }
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into PartList.ofPairs()", new Object[0]);
        for (int i = 0; i < pairs.length; i += 2) {
            x.add(BasicPart.of(pairs[i], pairs[i + 1]));
        }
        return x;
    }

    public PartList() {
        super(false);
    }

    protected PartList(PartList copyFrom) {
        super(false, copyFrom);
        this.caseInsensitive = copyFrom.caseInsensitive;
    }

    public PartList append(List<NameValuePair> values) {
        if (Utils.nn(values)) {
            values.forEach(this::append);
        }
        return this;
    }

    public PartList append(NameValuePair value) {
        if (Utils.nn(value)) {
            this.add(value);
        }
        return this;
    }

    public PartList append(NameValuePair ... values) {
        if (Utils.nn(values)) {
            for (NameValuePair value : values) {
                this.append(value);
            }
        }
        return this;
    }

    public PartList append(String name, Object value) {
        return this.append(this.createPart(name, value));
    }

    public PartList append(String name, Supplier<?> value) {
        return this.append(this.createPart(name, value));
    }

    public PartList caseInsensitive(boolean value) {
        this.assertModifiable();
        this.caseInsensitive = value;
        return this;
    }

    public boolean contains(String name) {
        return this.stream().anyMatch(x -> this.eq(x.getName(), name));
    }

    public PartList copy() {
        return new PartList(this);
    }

    public PartList forEach(Predicate<NameValuePair> filter, Consumer<NameValuePair> action) {
        this.forEach((? super E x) -> PredicateUtils.consumeIf(filter, action, x));
        return this;
    }

    public PartList forEach(String name, Consumer<NameValuePair> action) {
        return this.forEach((NameValuePair x) -> this.eq(name, x.getName()), action);
    }

    public PartList forEachValue(Predicate<NameValuePair> filter, Consumer<String> action) {
        return this.forEach(filter, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public PartList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public <T> Optional<T> get(Class<T> type) {
        AssertionUtils.assertArgNotNull("type", type);
        String name = PartBeanMeta.of(type).getSchema().getName();
        AssertionUtils.assertArg(Utils.nn(name), "Part name could not be found on bean type ''{0}''", Utils.cn(type));
        return this.get(name, type);
    }

    public Optional<NameValuePair> get(String name) {
        NameValuePair first = null;
        List<NameValuePair> rest = null;
        for (NameValuePair x : this) {
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return Utils.opte();
        }
        if (rest == null) {
            return Utils.opt(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (NameValuePair element : rest) {
            sb.append(',');
            sb.append(element.getValue());
        }
        return Utils.opt(new BasicStringPart(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        NameValuePair first = null;
        List<NameValuePair> rest = null;
        for (NameValuePair x : this) {
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return Utils.opte();
        }
        if (rest == null) {
            return Utils.opt(PartBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (NameValuePair element : rest) {
            sb.append(',');
            sb.append(element.getValue());
        }
        return Utils.opt(PartBeanMeta.of(type).construct(name, sb.toString()));
    }

    public NameValuePair[] getAll() {
        return (NameValuePair[])this.stream().toArray(NameValuePair[]::new);
    }

    public NameValuePair[] getAll(String name) {
        return (NameValuePair[])this.stream().filter(x -> this.eq(x.getName(), name)).toArray(NameValuePair[]::new);
    }

    public Optional<NameValuePair> getFirst(String name) {
        for (int i = 0; i < this.size(); ++i) {
            NameValuePair x = (NameValuePair)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return Utils.opt(x);
        }
        return Utils.opte();
    }

    public Optional<NameValuePair> getLast(String name) {
        for (int i = this.size() - 1; i >= 0; --i) {
            NameValuePair x = (NameValuePair)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return Utils.opt(x);
        }
        return Utils.opte();
    }

    public String[] getValues(String name) {
        return (String[])this.stream().filter(x -> this.eq(x.getName(), name)).map(NameValuePair::getValue).toArray(String[]::new);
    }

    public PartIterator partIterator() {
        return new BasicPartIterator(this.toArray(new NameValuePair[0]), null, this.caseInsensitive);
    }

    public PartIterator partIterator(String name) {
        return new BasicPartIterator(this.getAll(name), name, this.caseInsensitive);
    }

    public PartList prepend(List<NameValuePair> values) {
        if (Utils.nn(values)) {
            this.addAll(0, values);
        }
        return this;
    }

    public PartList prepend(NameValuePair value) {
        if (Utils.nn(value)) {
            this.add(0, value);
        }
        return this;
    }

    public PartList prepend(NameValuePair ... values) {
        if (Utils.nn(values)) {
            this.prepend(CollectionUtils.l(values));
        }
        return this;
    }

    public PartList prepend(String name, Object value) {
        return this.prepend(this.createPart(name, value));
    }

    public PartList prepend(String name, Supplier<?> value) {
        return this.prepend(this.createPart(name, value));
    }

    public PartList remove(List<NameValuePair> values) {
        if (Utils.nn(values)) {
            values.forEach(this::remove);
        }
        return this;
    }

    public PartList remove(NameValuePair value) {
        if (Utils.nn(value)) {
            this.removeIf(x -> this.eq(x.getName(), value.getName()) && this.eq(x.getValue(), value.getValue()));
        }
        return this;
    }

    public PartList remove(NameValuePair ... values) {
        for (NameValuePair value : values) {
            this.remove(value);
        }
        return this;
    }

    public PartList remove(String name) {
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public PartList remove(String ... names) {
        if (Utils.nn(names)) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    public PartList resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public PartList resolving(VarResolver varResolver) {
        this.assertModifiable();
        this.varResolver = varResolver;
        return this;
    }

    public PartList set(List<NameValuePair> values) {
        if (Utils.nn(values)) {
            for (NameValuePair h : values) {
                if (!Utils.nn(h)) continue;
                int j2 = this.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    NameValuePair x = (NameValuePair)this.get(i2);
                    if (!this.eq(x.getName(), h.getName())) continue;
                    this.remove(i2);
                    --j2;
                }
            }
            for (NameValuePair x : values) {
                if (!Utils.nn(x)) continue;
                this.add(x);
            }
        }
        return this;
    }

    public PartList set(NameValuePair value) {
        if (Utils.nn(value)) {
            boolean replaced = false;
            int j = this.size();
            for (int i = 0; i < j; ++i) {
                NameValuePair x = (NameValuePair)this.get(i);
                if (!this.eq(x.getName(), value.getName())) continue;
                if (replaced) {
                    this.remove(i);
                    --j;
                    continue;
                }
                this.set(i, value);
                replaced = true;
            }
            if (!replaced) {
                this.add(value);
            }
        }
        return this;
    }

    public PartList set(NameValuePair ... values) {
        if (Utils.nn(values)) {
            this.set(CollectionUtils.l(values));
        }
        return this;
    }

    public PartList set(String name, Object value) {
        return this.set(this.createPart(name, value));
    }

    public PartList set(String name, Supplier<?> value) {
        return this.set(this.createPart(name, value));
    }

    public PartList setDefault(List<NameValuePair> parts) {
        if (Utils.nn(parts)) {
            parts.stream().filter(x -> Utils.nn(x) && !this.contains(x.getName())).forEach(this::set);
        }
        return this;
    }

    public PartList setDefault(NameValuePair ... parts) {
        if (Utils.nn(parts)) {
            this.setDefault(CollectionUtils.l(parts));
        }
        return this;
    }

    public PartList setDefault(String name, Object value) {
        return this.setDefault(this.createPart(name, value));
    }

    public PartList setDefault(String name, Supplier<?> value) {
        return this.setDefault(this.createPart(name, value));
    }

    public PartList setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    public Stream<NameValuePair> stream(String name) {
        return this.stream().filter(x -> this.eq(name, x.getName()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach((? super E p) -> {
            String v;
            if (Utils.nn(p) && Utils.nn(v = p.getValue())) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(StringUtils.urlEncode(p.getName())).append('=').append(StringUtils.urlEncode(p.getValue()));
            }
        });
        return sb.toString();
    }

    private NameValuePair createPart(String name, Object value) {
        boolean isResolving = Utils.nn(this.varResolver);
        if (value instanceof Supplier) {
            Supplier value2 = (Supplier)value;
            return isResolving ? new BasicPart(name, this.resolver(value2)) : new BasicPart(name, value2);
        }
        return isResolving ? new BasicPart(name, this.resolver(value)) : new BasicPart(name, value);
    }

    private boolean eq(String s1, String s2) {
        return Utils.eq(this.caseInsensitive, s1, s2);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver.resolve(Utils.s(PartList.unwrap(input)));
    }

    private static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            Supplier s = (Supplier)o;
            o = s.get();
        }
        return o;
    }

    public static final class Void
    extends PartList {
        private static final long serialVersionUID = 1L;
    }
}

