/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;

@Header(value="Retry-After")
public class RetryAfter
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Retry-After";
    private final Integer value;
    private final Supplier<?> supplier;

    public static RetryAfter of(Integer value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(String value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(Supplier<?> value) {
        return value == null ? null : new RetryAfter(value);
    }

    public static RetryAfter of(ZonedDateTime value) {
        return value == null ? null : new RetryAfter(value);
    }

    public RetryAfter(Integer value) {
        super(NAME, (String)null);
        this.value = value;
        this.supplier = null;
    }

    public RetryAfter(String value) {
        super(NAME, StringUtils.isNumeric((String)value) ? null : value);
        this.value = StringUtils.isNumeric((String)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
        this.supplier = null;
    }

    public RetryAfter(Supplier<?> value) {
        super(NAME, (String)null);
        this.value = null;
        this.supplier = value;
    }

    public RetryAfter(ZonedDateTime value) {
        super(NAME, value);
        this.value = null;
        this.supplier = null;
    }

    public Optional<Integer> asInteger() {
        if (Utils.nn(this.supplier)) {
            Integer o2;
            Object o = this.supplier.get();
            return Utils.opt(o instanceof Integer ? (o2 = (Integer)o) : null);
        }
        return Utils.opt((Object)this.value);
    }

    @Override
    public String getValue() {
        if (Utils.nn(this.supplier)) {
            Object o = this.supplier.get();
            if (o == null) {
                return null;
            }
            if (o instanceof Integer) {
                Integer o2 = (Integer)o;
                return o2.toString();
            }
            if (o instanceof ZonedDateTime) {
                ZonedDateTime o2 = (ZonedDateTime)o;
                return DateTimeFormatter.RFC_1123_DATE_TIME.format(o2);
            }
            throw ThrowableUtils.rex((String)"Invalid object type returned by supplier: {0}", (Object[])new Object[]{Utils.cn(o)});
        }
        if (Utils.nn((Object)this.value)) {
            return Utils.s((Object)this.value);
        }
        return super.getValue();
    }
}

