/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.juneau.commons.utils.AssertionUtils;

public class FluentSet<E>
extends AbstractSet<E> {
    private final Set<E> set;

    public FluentSet(Set<E> inner) {
        this.set = AssertionUtils.assertArgNotNull("inner", inner);
    }

    public FluentSet<E> a(E element) {
        this.set.add(element);
        return this;
    }

    public FluentSet<E> aa(Collection<? extends E> c) {
        if (c != null) {
            this.set.addAll(c);
        }
        return this;
    }

    public FluentSet<E> ai(boolean condition, E element) {
        if (condition) {
            this.set.add(element);
        }
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }
}

