/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import org.apache.juneau.annotation.Marshalled;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.Utils;

public class MarshalledFilter {
    private final Class<?> marshalledClass;
    private final Class<?> implClass;
    private final String example;

    public static <T> Builder create(Class<T> marshalledClass) {
        return new Builder(marshalledClass);
    }

    protected MarshalledFilter(Builder builder) {
        this.marshalledClass = builder.marshalledClass;
        this.implClass = builder.implClass;
        this.example = builder.example;
    }

    public String getExample() {
        return this.example;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public Class<?> getMarshalledClass() {
        return this.marshalledClass;
    }

    public static class Builder {
        Class<?> marshalledClass;
        Class<?> implClass;
        String example;

        protected Builder(Class<?> marshalledClass) {
            this.marshalledClass = marshalledClass;
        }

        public Builder applyAnnotations(List<Marshalled> annotations) {
            annotations.forEach(x -> {
                if (ClassUtils.isNotVoid(x.implClass())) {
                    this.implClass(x.implClass());
                }
                if (Utils.ne(x.example())) {
                    this.example(x.example());
                }
            });
            return this;
        }

        public MarshalledFilter build() {
            return new MarshalledFilter(this);
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }
    }
}

