/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.rest.client.remote.RemoteOperationMeta;
import org.apache.juneau.svl.VarResolver;

public class RemoteMeta {
    private final Map<Method, RemoteOperationMeta> operations;
    private final HeaderList headers;

    private static String resolve(String s) {
        return VarResolver.DEFAULT.resolve(s);
    }

    public RemoteMeta(Class<?> c) {
        String path = "";
        ClassInfoTyped<?> ci = ClassInfo.of(c);
        List<Remote> remotes = CollectionUtils.rstream(ci.getAnnotations(Remote.class).toList()).map(AnnotationInfo::inner).toList();
        String versionHeader = "Client-Version";
        String clientVersion = null;
        HeaderList headers = HeaderList.create().resolving();
        for (Remote r : remotes) {
            if (Utils.ne(r.path())) {
                path = StringUtils.trimSlashes(RemoteMeta.resolve(r.path()));
            }
            for (String h : r.headers()) {
                headers.append((Header)HttpHeaders.stringHeader(RemoteMeta.resolve(h)));
            }
            if (Utils.ne(r.version())) {
                clientVersion = RemoteMeta.resolve(r.version());
            }
            if (Utils.ne(r.versionHeader())) {
                versionHeader = RemoteMeta.resolve(r.versionHeader());
            }
            if (!ClassUtils.isNotVoid(r.headerList())) continue;
            try {
                headers.append(r.headerList().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getAll());
            }
            catch (Exception e) {
                throw ThrowableUtils.rex(e, "Could not instantiate HeaderSupplier class", new Object[0]);
            }
        }
        if (Utils.nn(clientVersion)) {
            headers.append((Header)HttpHeaders.stringHeader(versionHeader, clientVersion));
        }
        LinkedHashMap operations = CollectionUtils.map();
        String path2 = path;
        ci.getPublicMethods().stream().forEach(x -> operations.put(x.inner(), new RemoteOperationMeta(path2, x.inner(), "GET")));
        this.operations = CollectionUtils.u(operations);
        this.headers = headers;
    }

    public HeaderList getHeaders() {
        return this.headers;
    }

    public RemoteOperationMeta getOperationMeta(Method m) {
        return this.operations.get(m);
    }
}

