/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.referencing.CC_OperationMethod;
import org.apache.sis.xml.bind.referencing.CC_OperationParameterGroup;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

@XmlType(name="AbstractSingleOperationType", propOrder={"method", "parameters"})
@XmlRootElement(name="AbstractSingleOperation")
@XmlSeeAlso(value={DefaultConversion.class, DefaultTransformation.class})
class AbstractSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation,
Parameterized {
    private static final long serialVersionUID = -2635450075620911309L;
    private OperationMethod method;
    ParameterValueGroup parameters;

    public AbstractSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, interpolationCRS, transform);
        ArgumentChecks.ensureNonNull("method", method);
        ArgumentChecks.ensureNonNull("transform", transform);
        this.method = method;
        this.setParameterValues(Containers.property(properties, "parameters", ParameterValueGroup.class), null);
    }

    AbstractSingleOperation(Map<String, ?> properties, OperationMethod method) {
        super(properties);
        ArgumentChecks.ensureNonNull("method", method);
        this.method = method;
    }

    protected AbstractSingleOperation(SingleOperation operation) {
        super(operation);
        this.method = operation.getMethod();
        this.parameters = Parameters.unmodifiable(operation.getParameterValues());
    }

    @Override
    @XmlElement(name="method", required=true)
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.parameters != null ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters : super.getParameterValues();
    }

    final void setParameterValues(ParameterValueGroup definition, Map<String, Boolean> ignore) {
        Predicate<GeneralParameterDescriptor> filter = null;
        if (ignore != null) {
            for (GeneralParameterDescriptor accepted : this.method.getParameters().descriptors()) {
                ignore.remove(accepted.getName().getCode());
                for (GenericName alias : accepted.getAlias()) {
                    ignore.remove(alias.tip().toString());
                }
            }
            filter = candidate -> {
                Boolean isContextual;
                block1: {
                    GenericName alias;
                    isContextual = (Boolean)ignore.get(candidate.getName().getCode());
                    if (isContextual != null) break block1;
                    Iterator<GenericName> iterator = candidate.getAlias().iterator();
                    while (iterator.hasNext() && (isContextual = (Boolean)ignore.get((alias = iterator.next()).tip().toString())) == null) {
                    }
                }
                return !Boolean.TRUE.equals(isContextual);
            };
        }
        this.parameters = Parameters.unmodifiable(definition, filter);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractSingleOperation that = (AbstractSingleOperation)object;
                return Objects.equals(this.method, that.method) && Objects.equals(this.parameters, that.parameters);
            }
            case BY_CONTRACT: {
                SingleOperation that = (SingleOperation)object;
                return Utilities.deepEquals(this.getMethod(), that.getMethod(), mode) && Utilities.deepEquals(this.getParameterValues(), that.getParameterValues(), mode);
            }
        }
        return true;
    }

    AbstractSingleOperation() {
    }

    private void setMethod(OperationMethod value) {
        if (this.method == null) {
            this.method = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractSingleOperation.class, "setMethod", "method");
        }
    }

    @XmlElement(name="parameterValue")
    private GeneralParameterValue[] getParameters() {
        List<GeneralParameterValue> values;
        if (this.parameters != null && (values = this.parameters.values()) != null) {
            return CC_OperationMethod.filterImplicit((GeneralParameterValue[])values.toArray(GeneralParameterValue[]::new));
        }
        return null;
    }

    private void setParameters(GeneralParameterValue[] values) {
        if (this.parameters == null) {
            if (!(this.method instanceof DefaultOperationMethod)) {
                throw new GeodeticException(Identifiers.missingValueForProperty(this.getName(), "method"));
            }
            IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
            GeneralParameterDescriptor[] merged = CC_OperationParameterGroup.merge(this.method.getParameters().descriptors(), Parameters.getDescriptors(values), replacements);
            for (int i = 0; i < merged.length; ++i) {
                if (merged[i] == values[i].getDescriptor()) continue;
                ((DefaultOperationMethod)this.method).updateDescriptors(merged);
                break;
            }
            this.parameters = new DefaultParameterValueGroup(this.method.getParameters());
            CC_OperationMethod.store(values, this.parameters.values(), replacements);
            this.parameters = Parameters.unmodifiable(this.parameters);
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractSingleOperation.class, "setParameters", "parameterValue");
        }
    }

    @Override
    final void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        ParameterDescriptorGroup descriptor;
        super.afterUnmarshal(unmarshaller, parent);
        if (this.parameters == null && this.method != null && (descriptor = this.method.getParameters()) != null && descriptor.descriptors().isEmpty()) {
            this.parameters = descriptor.createValue();
        }
        CoordinateReferenceSystem sourceCRS = super.getSourceCRS();
        CoordinateReferenceSystem targetCRS = super.getTargetCRS();
        if (this.transform == null && sourceCRS != null && targetCRS != null && this.parameters != null) {
            try {
                this.transform = ReferencingUtilities.createBaseToDerived(DefaultMathTransformFactory.provider(), sourceCRS, this.parameters, targetCRS);
            }
            catch (FactoryException e2) {
                Context.warningOccured(Context.current(), AbstractSingleOperation.class, "afterUnmarshal", e2, true);
            }
        }
    }
}

