/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.runner;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.FusekiMain;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.runner.AbstractRunner;
import org.apache.jena.fuseki.main.runner.FusekiRunnerLogging;
import org.apache.jena.fuseki.main.runner.Runner;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.mod.admin.FMod_Admin;
import org.apache.jena.fuseki.mod.prometheus.FMod_Prometheus;
import org.apache.jena.fuseki.mod.shiro.FMod_Shiro;
import org.apache.jena.fuseki.mod.system.FMod_Ping;
import org.apache.jena.fuseki.mod.ui.FMod_UI;
import org.apache.jena.sys.JenaSystem;

public class FusekiRunner {
    public static void execBasic(String ... args) {
        FusekiRunner.announcementExec(FusekiForm.BASIC);
        FusekiRunner.runnerBasic().exec(args);
    }

    public static void execMain(String ... args) {
        FusekiRunner.announcementExec(FusekiForm.MAIN);
        FusekiRunner.runnerMain().exec(args);
    }

    public static void execServerPlain(String ... args) {
        FusekiRunner.announcementExec(FusekiForm.SERVER_PLAIN);
        FusekiRunner.runnerServerPlain().exec(args);
    }

    public static void execServerUI(String ... args) {
        FusekiRunner.announcementExec(FusekiForm.SERVER);
        FusekiRunner.runnerServerUI().exec(args);
    }

    public static FusekiServer runAsyncBasic(String ... args) {
        FusekiRunner.announcementAsync(FusekiForm.BASIC);
        return FusekiRunner.runnerBasic().runAsync(args);
    }

    public static FusekiServer runAsyncMain(String ... args) {
        FusekiRunner.announcementAsync(FusekiForm.MAIN);
        return FusekiRunner.runnerMain().runAsync(args);
    }

    public static FusekiServer runAsyncServerPlain(String ... args) {
        FusekiRunner.announcementAsync(FusekiForm.SERVER_PLAIN);
        return FusekiRunner.runnerServerPlain().runAsync(args);
    }

    public static FusekiServer runAsyncServerUI(String ... args) {
        FusekiRunner.announcementAsync(FusekiForm.SERVER);
        return FusekiRunner.runnerServerUI().runAsync(args);
    }

    public static Runner basic() {
        return FusekiRunner.runnerBasic();
    }

    public static Runner main() {
        return FusekiRunner.runnerMain();
    }

    public static Runner serverPlain() {
        return FusekiRunner.runnerServerPlain();
    }

    public static Runner serverUI() {
        return FusekiRunner.runnerServerUI();
    }

    private static void announcementExec(FusekiForm form) {
        switch (form.ordinal()) {
            default: 
        }
        FusekiRunnerLogging.logCode(Fuseki.fusekiLog);
    }

    private static void announcementAsync(FusekiForm form) {
        switch (form.ordinal()) {
            default: 
        }
        FusekiRunnerLogging.logCode(Fuseki.fusekiLog);
    }

    private static Runner runnerBasic() {
        return FusekiRunner.setup(FusekiRunner.fmodsBasic());
    }

    private static Runner runnerMain() {
        return FusekiRunner.setup(FusekiRunner.fmodsMain());
    }

    private static Runner runnerServerPlain() {
        return FusekiRunner.setup(FusekiRunner.fmodsServerPlain());
    }

    private static Runner runnerServerUI() {
        return FusekiRunner.setup(FusekiRunner.fmodsServerUI());
    }

    private static FusekiModules fmods(FusekiModule ... fmods) {
        return FusekiModules.add(FusekiModules.getSystemModules(), fmods);
    }

    private static FusekiModules fmods0(FusekiModule ... fmods) {
        return FusekiModules.create(fmods);
    }

    public static FusekiModules fmodsBasic() {
        return FusekiModules.empty();
    }

    public static FusekiModules fmodsMain() {
        return FusekiRunner.fmods0(FMod_Ping.create(), FMod_Shiro.create(), FMod_Prometheus.create());
    }

    public static FusekiModules fmodsServerPlain() {
        return FusekiRunner.fmods(FMod_Ping.create(), FMod_Shiro.create(), FMod_Prometheus.create());
    }

    public static FusekiModules fmodsServerUI() {
        return FusekiRunner.fmods(FMod_Admin.create(), FMod_UI.create(), FMod_Shiro.create(), FMod_Prometheus.create());
    }

    private static FusekiServer.Builder builder(FusekiModules fmods, String ... args) {
        return FusekiMain.builder(fmods, args);
    }

    private static Runner setup(FusekiModules fmods) {
        return new RunnerMods(fmods);
    }

    static {
        JenaSystem.init();
    }

    static enum FusekiForm {
        BASIC("basic"),
        MAIN("main"),
        SERVER_PLAIN("server/plain"),
        SERVER("server/ui");

        final String fusekiFormName;

        private FusekiForm(String string2) {
            this.fusekiFormName = string2;
        }
    }

    static class RunnerMods
    extends AbstractRunner {
        private final FusekiModules modules;

        RunnerMods(FusekiModules modules) {
            this.modules = modules;
        }

        @Override
        protected FusekiServer.Builder builder(String ... args) {
            return FusekiRunner.builder(this.modules, args);
        }
    }
}

