/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.assembler;

import org.apache.jena.assembler.JA;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdfs.assembler.DatasetRDFSAssembler;
import org.apache.jena.rdfs.assembler.GraphRDFSAssembler;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sys.JenaSystem;

public class VocabRDFS {
    public static final String NS;
    public static final Resource tDatasetRDFS;
    public static final Resource tGraphRDFS;
    public static final Resource tModelRDFS;
    public static final Property pRdfsSchemaFile;
    public static final Property pDataset;
    public static final Property pGraph;
    private static boolean initialized;

    public static String getURI() {
        return NS;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.registerDataset(tDatasetRDFS, new DatasetRDFSAssembler());
        GraphRDFSAssembler a = new GraphRDFSAssembler();
        AssemblerUtils.registerModel(tGraphRDFS, a);
        AssemblerUtils.registerModel(tModelRDFS, a);
    }

    private static Resource resource(String localname2) {
        return ResourceFactory.createResource((String)VocabRDFS.iri(localname2));
    }

    private static Property property(String localname2) {
        return ResourceFactory.createProperty((String)VocabRDFS.iri(localname2));
    }

    private static String iri(String localname2) {
        String uri = NS + localname2;
        return uri;
    }

    static {
        JenaSystem.init();
        NS = JA.getURI();
        tDatasetRDFS = VocabRDFS.resource("DatasetRDFS");
        tGraphRDFS = VocabRDFS.resource("GraphRDFS");
        tModelRDFS = VocabRDFS.resource("ModelRDFS");
        pRdfsSchemaFile = VocabRDFS.property("rdfsSchema");
        pDataset = DatasetAssemblerVocab.pDataset;
        pGraph = DatasetAssemblerVocab.pGraph;
        initialized = false;
        VocabRDFS.init();
    }
}

