/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternTreeUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class AlterEncodingCompressorStatement
extends Statement
implements IConfigStatement {
    private PathPatternTree patternTree;
    private final TSEncoding encoding;
    private final CompressionType compressor;
    private final boolean ifExists;
    private final boolean ifPermitted;
    private boolean withAudit = false;

    public AlterEncodingCompressorStatement(PathPatternTree pathPatternTree, TSEncoding encoding, CompressionType compressor, boolean ifExists, boolean ifPermitted) {
        this.statementType = StatementType.ALTER_ENCODING_COMPRESSOR;
        this.patternTree = pathPatternTree;
        this.encoding = encoding;
        this.compressor = compressor;
        this.ifExists = ifExists;
        this.ifPermitted = ifPermitted;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean ifPermitted() {
        return this.ifPermitted;
    }

    public void setWithAudit(boolean withAudit) {
        this.withAudit = withAudit;
    }

    public boolean isWithAudit() {
        return this.withAudit;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return this.patternTree.getAllPathPatterns();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterEncodingCompressorStatement that = (AlterEncodingCompressorStatement)obj;
        return Objects.equals(this.patternTree, that.patternTree) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.compressor, that.compressor) && Objects.equals(this.ifExists, that.ifExists) && Objects.equals(this.ifPermitted, that.ifPermitted);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        if (this.ifPermitted) {
            try {
                PathPatternTree authTree = AuthorityChecker.getAuthorizedPathTree(userName, PrivilegeType.WRITE_SCHEMA);
                this.setPatternTree(PathPatternTreeUtils.intersectWithFullPathPrefixTree((PathPatternTree)this.getPatternTree(), (PathPatternTree)authTree));
                return StatusUtils.OK;
            }
            catch (AuthException e) {
                return new TSStatus(e.getCode().getStatusCode());
            }
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathOrPatternListPermission(userName, this.getPaths(), PrivilegeType.WRITE_SCHEMA), this.getPaths(), PrivilegeType.WRITE_SCHEMA);
    }

    public int hashCode() {
        return Objects.hash(this.patternTree, this.encoding, this.compressor, this.ifExists, this.ifPermitted);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAlterEncodingCompressor(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

