/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encrypt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IEncrypt;
import org.apache.tsfile.exception.encrypt.EncryptException;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDecryptor {
    public static final Logger logger = LoggerFactory.getLogger(IDecryptor.class);

    public static IDecryptor getDecryptor(String type, byte[] key) {
        try {
            String className = EncryptUtils.getEncryptClass(type);
            if (IEncrypt.encryptMap.containsKey(className)) {
                return ((IEncrypt)IEncrypt.encryptMap.get(className).newInstance(new Object[]{key})).getDecryptor();
            }
            Class<?> encryptClass = Class.forName(className);
            Constructor<?> constructor = encryptClass.getDeclaredConstructor(byte[].class);
            IEncrypt.encryptMap.put(className, constructor);
            return ((IEncrypt)constructor.newInstance(new Object[]{key})).getDecryptor();
        }
        catch (ClassNotFoundException e) {
            throw new EncryptException("Get decryptor class failed, class not found: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new EncryptException("Get constructor for decryptor failed: " + type, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EncryptException("New decryptor instance failed: " + type, e);
        }
    }

    public static IDecryptor getDecryptor(EncryptParameter encryptParam) {
        String type = encryptParam.getType();
        byte[] key = encryptParam.getKey();
        return IDecryptor.getDecryptor(type, key);
    }

    public byte[] decrypt(byte[] var1);

    public byte[] decrypt(byte[] var1, int var2, int var3);

    public EncryptionType getEncryptionType();
}

