/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FrameBound
extends Node {
    private final Type type;
    private final Optional<Expression> value;

    public FrameBound(NodeLocation location, Type type) {
        this(location, type, null);
    }

    public FrameBound(NodeLocation location, Type type, Expression value) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = Optional.ofNullable(value);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFrameBound(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.value.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameBound o = (FrameBound)obj;
        return this.type == o.type && Objects.equals(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", this.value).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FrameBound.sameClass(this, other)) {
            return false;
        }
        FrameBound otherNode = (FrameBound)other;
        return this.type == otherNode.type;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (ByteBuffer)buffer);
        if (this.value.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            Expression.serialize(this.value.get(), buffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (OutputStream)stream);
        if (this.value.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.value.get(), stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public FrameBound(ByteBuffer byteBuffer) {
        super(null);
        this.type = Type.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
        this.value = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(Expression.deserialize(byteBuffer)) : Optional.empty();
    }

    public static enum Type {
        UNBOUNDED_PRECEDING,
        PRECEDING,
        CURRENT_ROW,
        FOLLOWING,
        UNBOUNDED_FOLLOWING;

    }
}

