/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.memory.AtomicLongMemoryBlock;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManagerMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(IoTConsensusMemoryManager.class);
    private final AtomicLong queueMemorySizeInByte = new AtomicLong(0L);
    private final AtomicLong syncMemorySizeInByte = new AtomicLong(0L);
    private IMemoryBlock memoryBlock = new AtomicLongMemoryBlock("Consensus-Default", null, Runtime.getRuntime().maxMemory() / 10L);
    private Double maxMemoryRatioForQueue = 0.6;
    private static final IoTConsensusMemoryManager INSTANCE = new IoTConsensusMemoryManager();

    private IoTConsensusMemoryManager() {
        MetricService.getInstance().addMetricSet((IMetricSet)new IoTConsensusMemoryManagerMetrics(this));
    }

    public boolean reserve(long size, boolean fromQueue) {
        boolean result;
        boolean bl = result = fromQueue ? this.memoryBlock.allocateIfSufficient(size, this.maxMemoryRatioForQueue.doubleValue()) : this.memoryBlock.allocate(size);
        if (result) {
            if (fromQueue) {
                this.queueMemorySizeInByte.addAndGet(size);
            } else {
                this.syncMemorySizeInByte.addAndGet(size);
            }
        }
        return result;
    }

    public void free(long size, boolean fromQueue) {
        long currentUsedMemory = this.memoryBlock.release(size);
        if (fromQueue) {
            this.queueMemorySizeInByte.addAndGet(-size);
        } else {
            this.syncMemorySizeInByte.addAndGet(-size);
        }
        logger.debug("{} free {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, currentUsedMemory});
    }

    public void init(IMemoryBlock memoryBlock, double maxMemoryRatioForQueue) {
        this.memoryBlock = memoryBlock;
        this.maxMemoryRatioForQueue = maxMemoryRatioForQueue;
    }

    long getMemorySizeInByte() {
        return this.memoryBlock.getUsedMemoryInBytes();
    }

    long getQueueMemorySizeInByte() {
        return this.queueMemorySizeInByte.get();
    }

    long getSyncMemorySizeInByte() {
        return this.syncMemorySizeInByte.get();
    }

    public static IoTConsensusMemoryManager getInstance() {
        return INSTANCE;
    }
}

