/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupCheck;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartupChecks {
    private static final Logger logger = LoggerFactory.getLogger(StartupChecks.class);
    private final String nodeRole;
    protected final List<StartupCheck> preChecks = new ArrayList<StartupCheck>();

    protected StartupChecks(String nodeRole) {
        this.nodeRole = nodeRole;
    }

    private void checkJMXPort(String nodeRole) {
        boolean jmxLocal = Boolean.parseBoolean(System.getProperty("iotdb.jmx.local"));
        String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
        if (jmxLocal) {
            logger.info("Start JMX locally.");
            return;
        }
        if (jmxPort == null) {
            String filename = nodeRole.equals("datanode") ? "datanode-env" : "confignode-env";
            logger.warn("{} missing from {}.sh(Unix or OS X, if you use Windows, check conf/{}.bat)", new Object[]{"com.sun.management.jmxremote.port", filename, filename});
        } else {
            logger.info("Start JMX remotely: JMX is enabled to receive remote connection on port {}", (Object)jmxPort);
        }
    }

    private void checkJDK() throws StartupException {
        int version = JVMCommonUtils.getJdkVersion();
        if (version < 8) {
            throw new StartupException(String.format("Requires JDK version >= %d, current version is %d.", 8, version));
        }
        logger.info("JDK version is {}.", (Object)version);
    }

    private void checkJVM() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        logger.info("JVM version is {} {}.", (Object)bean.getVmName(), (Object)bean.getVmVersion());
        try {
            Class.forName("org.graalvm.home.Version");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        logger.warn("Perhaps you are using GraalVM, which is strongly not recommended. Using GraalVM may cause strange problems after the system runs for a while. Please check your JVM version.");
    }

    protected void envCheck() {
        this.preChecks.add(() -> this.checkJMXPort(this.nodeRole));
        this.preChecks.add(this::checkJDK);
        this.preChecks.add(this::checkJVM);
    }

    protected void verify() throws StartupException {
        for (StartupCheck check : this.preChecks) {
            check.execute();
        }
    }

    protected abstract void portCheck() throws StartupException;

    protected abstract void startUpCheck() throws Exception;
}

