/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.NumberDataPointStatelessMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Sum;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import java.io.IOException;
import java.util.Collection;

final class SumStatelessMarshaler
implements StatelessMarshaler<SumData<? extends PointData>> {
    static final SumStatelessMarshaler INSTANCE = new SumStatelessMarshaler();
    private static final MarshalerContext.Key DATA_POINT_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key DATA_POINT_WRITER_KEY = MarshalerContext.key();

    SumStatelessMarshaler() {
    }

    public void writeTo(Serializer output, SumData<? extends PointData> sum, MarshalerContext context) throws IOException {
        output.serializeRepeatedMessageWithContext(Sum.DATA_POINTS, sum.getPoints(), (StatelessMarshaler)NumberDataPointStatelessMarshaler.INSTANCE, context, DATA_POINT_WRITER_KEY);
        output.serializeEnum(Sum.AGGREGATION_TEMPORALITY, MetricsMarshalerUtil.mapToTemporality(sum.getAggregationTemporality()));
        output.serializeBool(Sum.IS_MONOTONIC, sum.isMonotonic());
    }

    public int getBinarySerializedSize(SumData<? extends PointData> sum, MarshalerContext context) {
        int size = 0;
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Sum.DATA_POINTS, (Collection)sum.getPoints(), (StatelessMarshaler)NumberDataPointStatelessMarshaler.INSTANCE, (MarshalerContext)context, (MarshalerContext.Key)DATA_POINT_SIZE_CALCULATOR_KEY);
        size += MarshalerUtil.sizeEnum((ProtoFieldInfo)Sum.AGGREGATION_TEMPORALITY, (ProtoEnumInfo)MetricsMarshalerUtil.mapToTemporality(sum.getAggregationTemporality()));
        return size += MarshalerUtil.sizeBool((ProtoFieldInfo)Sum.IS_MONOTONIC, (boolean)sum.isMonotonic());
    }
}

