/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.reactive.common.util.HeaderParameterParser;
import org.jboss.resteasy.reactive.common.util.LocaleHelper;

public class WeightedLanguage
implements Comparable<WeightedLanguage> {
    private float weight = 1.0f;
    private String language;
    private Locale locale;
    private Map<String, String> params;

    public WeightedLanguage(Locale locale, float weight) {
        this.locale = locale;
        this.weight = weight;
    }

    private WeightedLanguage(String lang, Map<String, String> parameters) {
        String q;
        this.language = lang;
        this.params = parameters;
        this.locale = LocaleHelper.extractLocale(lang);
        if (this.params != null && (q = this.params.get("q")) != null) {
            this.weight = WeightedLanguage.getQWithParamInfo(this, q);
        }
    }

    public float getWeight() {
        return this.weight;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int compareTo(WeightedLanguage o) {
        WeightedLanguage type2 = this;
        WeightedLanguage type1 = o;
        if (type1.weight < type2.weight) {
            return -1;
        }
        if (type1.weight > type2.weight) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        Object rtn = this.language;
        if (this.params == null || this.params.size() == 0) {
            return rtn;
        }
        for (String name : this.params.keySet()) {
            String val = this.params.get(name);
            rtn = (String)rtn + ";" + name + "=\"" + val + "\"";
        }
        return rtn;
    }

    public static WeightedLanguage parse(String lang) {
        String params = null;
        int idx = lang.indexOf(";");
        if (idx > -1) {
            params = lang.substring(idx + 1).trim();
            lang = lang.substring(0, idx);
        }
        HashMap<String, String> typeParams = new HashMap<String, String>();
        if (params != null && !params.equals("")) {
            int start = 0;
            while (start < params.length()) {
                start = HeaderParameterParser.setParam(typeParams, params, start);
            }
        }
        return new WeightedLanguage(lang, typeParams);
    }

    private static float getQWithParamInfo(WeightedLanguage lang, String val) {
        try {
            if (val != null) {
                float rtn = Float.valueOf(val).floatValue();
                if (rtn > 1.0f) {
                    throw new WebApplicationException("q value cannot be greater than one: " + lang.toString(), Response.Status.BAD_REQUEST);
                }
                return rtn;
            }
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException("media type weighted language q must be a float: " + lang.toString(), Response.Status.BAD_REQUEST);
        }
        return 1.0f;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

