/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ManifestPrinter
extends Configured
implements Tool {
    private static final String USAGE = "successfile <success-file>";
    private final PrintStream out;

    public ManifestPrinter() {
        this(null, System.out);
    }

    public ManifestPrinter(Configuration conf, PrintStream out) {
        super(conf);
        this.out = out;
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            this.printUsage();
            return -1;
        }
        Path path = new Path(args[0]);
        this.loadAndPrintManifest(path.getFileSystem(this.getConf()), path);
        return 0;
    }

    public ManifestSuccessData loadAndPrintManifest(FileSystem fs, Path path) throws IOException {
        this.println("Manifest file: %s", path);
        ManifestSuccessData success = ManifestSuccessData.load(fs, path);
        this.printManifest(success);
        return success;
    }

    public void printManifest(ManifestSuccessData success) {
        this.field("succeeded", success.getSuccess());
        this.field("created", success.getDate());
        this.field("committer", success.getCommitter());
        this.field("hostname", success.getHostname());
        this.field("description", success.getDescription());
        this.field("jobId", success.getJobId());
        this.field("jobIdSource", success.getJobIdSource());
        this.field("stage", success.getStage());
        this.println("Diagnostics\n%s", success.dumpDiagnostics("  ", " = ", "\n"));
        this.println("Statistics:\n%s", IOStatisticsLogging.ioStatisticsToPrettyString(success.getIOStatistics()));
        this.out.flush();
    }

    private void printUsage() {
        this.println(USAGE, new Object[0]);
    }

    private void println(String format, Object ... args) {
        this.out.format(format, args);
        this.out.println();
    }

    private void field(String name, Object value) {
        if (value != null) {
            this.println("%s: %s", name, value);
        }
    }

    public static void main(String[] argv) throws Exception {
        try {
            int res = ToolRunner.run(new ManifestPrinter(), argv);
            System.exit(res);
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.terminate(e);
        }
    }
}

