/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.policybuilder.iam.IamConditionKey;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.internal.DefaultIamCondition;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public interface IamCondition
extends ToCopyableBuilder<Builder, IamCondition> {
    public static IamCondition create(IamConditionOperator operator, IamConditionKey key, String value) {
        return (IamCondition)IamCondition.builder().operator(operator).key(key).value(value).build();
    }

    public static IamCondition create(IamConditionOperator operator, String key, String value) {
        return (IamCondition)IamCondition.builder().operator(operator).key(key).value(value).build();
    }

    public static IamCondition create(String operator, String key, String value) {
        return (IamCondition)IamCondition.builder().operator(operator).key(key).value(value).build();
    }

    public static List<IamCondition> createAll(IamConditionOperator operator, IamConditionKey key, Collection<String> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(value -> IamCondition.create(operator, key, value)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<IamCondition> createAll(IamConditionOperator operator, String key, Collection<String> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(value -> IamCondition.create(operator, key, value)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<IamCondition> createAll(String operator, String key, Collection<String> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(value -> IamCondition.create(operator, key, value)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static Builder builder() {
        return DefaultIamCondition.builder();
    }

    public IamConditionOperator operator();

    public IamConditionKey key();

    public String value();

    public static interface Builder
    extends CopyableBuilder<Builder, IamCondition> {
        public Builder operator(IamConditionOperator var1);

        public Builder operator(String var1);

        public Builder key(IamConditionKey var1);

        public Builder key(String var1);

        public Builder value(String var1);
    }
}

