/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.fallback.FallbackEvents;
import io.smallrye.faulttolerance.core.metrics.GeneralMetricsEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsLogger;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitEvents;
import io.smallrye.faulttolerance.core.retry.RetryEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsCollector<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final MetricsRecorder metrics;
    private final boolean mayBeAsync;
    private final boolean hasBulkhead;
    private final boolean hasCircuitBreaker;
    private final boolean hasRateLimit;
    private final boolean hasRetry;
    private final boolean hasTimeout;
    private volatile CircuitBreakerState state;
    private final AtomicLong previousHalfOpenTime = new AtomicLong();
    private volatile long halfOpenStart;
    private final AtomicLong previousClosedTime = new AtomicLong();
    private volatile long closedStart;
    private final AtomicLong previousOpenTime = new AtomicLong();
    private volatile long openStart;
    private final AtomicLong runningExecutions = new AtomicLong();
    private final AtomicLong waitingExecutions = new AtomicLong();

    public MetricsCollector(FaultToleranceStrategy<V> delegate, MetricsRecorder metrics, MeteredOperation operation) {
        this.delegate = delegate;
        this.metrics = metrics;
        this.mayBeAsync = operation.mayBeAsynchronous();
        this.hasBulkhead = operation.hasBulkhead();
        this.hasCircuitBreaker = operation.hasCircuitBreaker();
        this.hasRateLimit = operation.hasRateLimit();
        this.hasRetry = operation.hasRetry();
        this.hasTimeout = operation.hasTimeout();
        this.state = CircuitBreakerState.CLOSED;
        this.closedStart = System.nanoTime();
        if (this.hasCircuitBreaker) {
            metrics.registerCircuitBreakerIsClosed(() -> CircuitBreakerState.CLOSED == this.state);
            metrics.registerCircuitBreakerIsOpen(() -> CircuitBreakerState.OPEN == this.state);
            metrics.registerCircuitBreakerIsHalfOpen(() -> CircuitBreakerState.HALF_OPEN == this.state);
            metrics.registerCircuitBreakerTimeSpentInClosed(() -> this.getTime(CircuitBreakerState.CLOSED, this.closedStart, this.previousClosedTime));
            metrics.registerCircuitBreakerTimeSpentInOpen(() -> this.getTime(CircuitBreakerState.OPEN, this.openStart, this.previousOpenTime));
            metrics.registerCircuitBreakerTimeSpentInHalfOpen(() -> this.getTime(CircuitBreakerState.HALF_OPEN, this.halfOpenStart, this.previousHalfOpenTime));
        }
        if (this.hasBulkhead) {
            metrics.registerBulkheadExecutionsRunning(this.runningExecutions::get);
            if (this.mayBeAsync) {
                metrics.registerBulkheadExecutionsWaiting(this.waitingExecutions::get);
            }
        }
    }

    private long getTime(CircuitBreakerState measuredState, long measuredStateStart, AtomicLong prevMeasuredStateTime) {
        return this.state == measuredState ? prevMeasuredStateTime.get() + System.nanoTime() - measuredStateStart : prevMeasuredStateTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        MetricsLogger.LOG.trace("MetricsCollector started");
        try {
            Future<Object> originalResult;
            this.registerMetrics(ctx);
            Completer result = Completer.create();
            try {
                originalResult = this.delegate.apply(ctx);
            }
            catch (Exception e) {
                originalResult = Future.ofError(e);
            }
            originalResult.then((value, error) -> {
                if (error == null) {
                    ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.VALUE_RETURNED);
                    result.complete(value);
                } else {
                    ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.EXCEPTION_THROWN);
                    result.completeWithError((Throwable)error);
                }
            });
            Future future = result.future();
            return future;
        }
        finally {
            MetricsLogger.LOG.trace("MetricsCollector finished");
        }
    }

    private void registerMetrics(FaultToleranceContext<V> ctx) {
        AtomicBoolean fallbackDefined = new AtomicBoolean(false);
        AtomicBoolean fallbackApplied = new AtomicBoolean(false);
        ctx.registerEventHandler(FallbackEvents.Defined.class, ignored -> fallbackDefined.set(true));
        ctx.registerEventHandler(FallbackEvents.Applied.class, ignored -> fallbackApplied.set(true));
        ctx.registerEventHandler(GeneralMetricsEvents.ExecutionFinished.class, event -> this.metrics.executionFinished(event.succeeded, fallbackDefined.get(), fallbackApplied.get()));
        if (this.hasRetry) {
            AtomicBoolean retried = new AtomicBoolean(false);
            ctx.registerEventHandler(RetryEvents.Retried.class, ignored -> {
                this.metrics.retryAttempted();
                retried.set(true);
            });
            ctx.registerEventHandler(RetryEvents.Finished.class, event -> {
                if (RetryEvents.Result.VALUE_RETURNED == event.result) {
                    this.metrics.retryValueReturned(retried.get());
                } else if (RetryEvents.Result.EXCEPTION_NOT_RETRYABLE == event.result) {
                    this.metrics.retryExceptionNotRetryable(retried.get());
                } else if (RetryEvents.Result.MAX_RETRIES_REACHED == event.result) {
                    this.metrics.retryMaxRetriesReached(retried.get());
                } else if (RetryEvents.Result.MAX_DURATION_REACHED == event.result) {
                    this.metrics.retryMaxDurationReached(retried.get());
                }
            });
        }
        if (this.hasTimeout) {
            AtomicLong timeoutStart = new AtomicLong();
            ctx.registerEventHandler(TimeoutEvents.Started.class, ignored -> timeoutStart.set(System.nanoTime()));
            ctx.registerEventHandler(TimeoutEvents.Finished.class, event -> this.metrics.timeoutFinished(event.timedOut, System.nanoTime() - timeoutStart.get()));
        }
        if (this.hasCircuitBreaker) {
            ctx.registerEventHandler(CircuitBreakerEvents.Finished.class, event -> this.metrics.circuitBreakerFinished(event.result));
            ctx.registerEventHandler(CircuitBreakerEvents.StateTransition.class, event -> {
                this.state = event.targetState;
                long now = System.nanoTime();
                switch (event.targetState) {
                    case CLOSED: {
                        this.closedStart = now;
                        this.previousHalfOpenTime.addAndGet(now - this.halfOpenStart);
                        break;
                    }
                    case OPEN: {
                        this.openStart = now;
                        this.previousClosedTime.addAndGet(now - this.closedStart);
                        this.metrics.circuitBreakerMovedToOpen();
                        break;
                    }
                    case HALF_OPEN: {
                        this.halfOpenStart = now;
                        this.previousOpenTime.addAndGet(now - this.openStart);
                    }
                }
            });
        }
        if (this.hasBulkhead) {
            AtomicLong runningStart = new AtomicLong();
            ctx.registerEventHandler(BulkheadEvents.DecisionMade.class, event -> this.metrics.bulkheadDecisionMade(event.accepted));
            ctx.registerEventHandler(BulkheadEvents.StartedRunning.class, ignored -> {
                this.runningExecutions.incrementAndGet();
                runningStart.set(System.nanoTime());
            });
            ctx.registerEventHandler(BulkheadEvents.FinishedRunning.class, ignored -> {
                this.runningExecutions.decrementAndGet();
                this.metrics.updateBulkheadRunningDuration(System.nanoTime() - runningStart.get());
            });
            if (this.mayBeAsync) {
                AtomicLong waitingStart = new AtomicLong();
                ctx.registerEventHandler(BulkheadEvents.StartedWaiting.class, ignored -> {
                    this.waitingExecutions.incrementAndGet();
                    waitingStart.set(System.nanoTime());
                });
                ctx.registerEventHandler(BulkheadEvents.FinishedWaiting.class, ignored -> {
                    this.waitingExecutions.decrementAndGet();
                    this.metrics.updateBulkheadWaitingDuration(System.nanoTime() - waitingStart.get());
                });
            }
        }
        if (this.hasRateLimit) {
            ctx.registerEventHandler(RateLimitEvents.DecisionMade.class, event -> this.metrics.rateLimitDecisionMade(event.permitted));
        }
    }
}

