/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;

public class ListRetirableGrantsPublisher
implements SdkPublisher<ListRetirableGrantsResponse> {
    private final KmsAsyncClient client;
    private final ListRetirableGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRetirableGrantsPublisher(KmsAsyncClient client, ListRetirableGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRetirableGrantsPublisher(KmsAsyncClient client, ListRetirableGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRetirableGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRetirableGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GrantListEntry> grants() {
        Function<ListRetirableGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRetirableGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRetirableGrantsResponseFetcher
    implements AsyncPageFetcher<ListRetirableGrantsResponse> {
        private ListRetirableGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListRetirableGrantsResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public CompletableFuture<ListRetirableGrantsResponse> nextPage(ListRetirableGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListRetirableGrantsPublisher.this.client.listRetirableGrants(ListRetirableGrantsPublisher.this.firstRequest);
            }
            return ListRetirableGrantsPublisher.this.client.listRetirableGrants((ListRetirableGrantsRequest)((Object)ListRetirableGrantsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

