/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WrappingKeySpec {
    RSA_2048("RSA_2048"),
    RSA_3072("RSA_3072"),
    RSA_4096("RSA_4096"),
    SM2("SM2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WrappingKeySpec> VALUE_MAP;
    private final String value;

    private WrappingKeySpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WrappingKeySpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WrappingKeySpec> knownValues() {
        EnumSet<WrappingKeySpec> knownValues = EnumSet.allOf(WrappingKeySpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WrappingKeySpec.class, WrappingKeySpec::toString);
    }
}

