/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.ImportState;
import software.amazon.awssdk.services.kms.model.KeyMaterialState;
import software.amazon.awssdk.services.kms.model.RotationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotationsListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RotationsListEntry> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(RotationsListEntry.getter(RotationsListEntry::keyId)).setter(RotationsListEntry.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialId").getter(RotationsListEntry.getter(RotationsListEntry::keyMaterialId)).setter(RotationsListEntry.setter(Builder::keyMaterialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialId").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialDescription").getter(RotationsListEntry.getter(RotationsListEntry::keyMaterialDescription)).setter(RotationsListEntry.setter(Builder::keyMaterialDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialDescription").build()}).build();
    private static final SdkField<String> IMPORT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportState").getter(RotationsListEntry.getter(RotationsListEntry::importStateAsString)).setter(RotationsListEntry.setter(Builder::importState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportState").build()}).build();
    private static final SdkField<String> KEY_MATERIAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialState").getter(RotationsListEntry.getter(RotationsListEntry::keyMaterialStateAsString)).setter(RotationsListEntry.setter(Builder::keyMaterialState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialState").build()}).build();
    private static final SdkField<String> EXPIRATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationModel").getter(RotationsListEntry.getter(RotationsListEntry::expirationModelAsString)).setter(RotationsListEntry.setter(Builder::expirationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationModel").build()}).build();
    private static final SdkField<Instant> VALID_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidTo").getter(RotationsListEntry.getter(RotationsListEntry::validTo)).setter(RotationsListEntry.setter(Builder::validTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTo").build()}).build();
    private static final SdkField<Instant> ROTATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RotationDate").getter(RotationsListEntry.getter(RotationsListEntry::rotationDate)).setter(RotationsListEntry.setter(Builder::rotationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationDate").build()}).build();
    private static final SdkField<String> ROTATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationType").getter(RotationsListEntry.getter(RotationsListEntry::rotationTypeAsString)).setter(RotationsListEntry.setter(Builder::rotationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, KEY_MATERIAL_ID_FIELD, KEY_MATERIAL_DESCRIPTION_FIELD, IMPORT_STATE_FIELD, KEY_MATERIAL_STATE_FIELD, EXPIRATION_MODEL_FIELD, VALID_TO_FIELD, ROTATION_DATE_FIELD, ROTATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RotationsListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String keyMaterialId;
    private final String keyMaterialDescription;
    private final String importState;
    private final String keyMaterialState;
    private final String expirationModel;
    private final Instant validTo;
    private final Instant rotationDate;
    private final String rotationType;

    private RotationsListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyMaterialId = builder.keyMaterialId;
        this.keyMaterialDescription = builder.keyMaterialDescription;
        this.importState = builder.importState;
        this.keyMaterialState = builder.keyMaterialState;
        this.expirationModel = builder.expirationModel;
        this.validTo = builder.validTo;
        this.rotationDate = builder.rotationDate;
        this.rotationType = builder.rotationType;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String keyMaterialId() {
        return this.keyMaterialId;
    }

    public final String keyMaterialDescription() {
        return this.keyMaterialDescription;
    }

    public final ImportState importState() {
        return ImportState.fromValue(this.importState);
    }

    public final String importStateAsString() {
        return this.importState;
    }

    public final KeyMaterialState keyMaterialState() {
        return KeyMaterialState.fromValue(this.keyMaterialState);
    }

    public final String keyMaterialStateAsString() {
        return this.keyMaterialState;
    }

    public final ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(this.expirationModel);
    }

    public final String expirationModelAsString() {
        return this.expirationModel;
    }

    public final Instant validTo() {
        return this.validTo;
    }

    public final Instant rotationDate() {
        return this.rotationDate;
    }

    public final RotationType rotationType() {
        return RotationType.fromValue(this.rotationType);
    }

    public final String rotationTypeAsString() {
        return this.rotationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationsListEntry)) {
            return false;
        }
        RotationsListEntry other = (RotationsListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyMaterialId(), other.keyMaterialId()) && Objects.equals(this.keyMaterialDescription(), other.keyMaterialDescription()) && Objects.equals(this.importStateAsString(), other.importStateAsString()) && Objects.equals(this.keyMaterialStateAsString(), other.keyMaterialStateAsString()) && Objects.equals(this.expirationModelAsString(), other.expirationModelAsString()) && Objects.equals(this.validTo(), other.validTo()) && Objects.equals(this.rotationDate(), other.rotationDate()) && Objects.equals(this.rotationTypeAsString(), other.rotationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RotationsListEntry").add("KeyId", (Object)this.keyId()).add("KeyMaterialId", (Object)this.keyMaterialId()).add("KeyMaterialDescription", (Object)this.keyMaterialDescription()).add("ImportState", (Object)this.importStateAsString()).add("KeyMaterialState", (Object)this.keyMaterialStateAsString()).add("ExpirationModel", (Object)this.expirationModelAsString()).add("ValidTo", (Object)this.validTo()).add("RotationDate", (Object)this.rotationDate()).add("RotationType", (Object)this.rotationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyMaterialId": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialId()));
            }
            case "KeyMaterialDescription": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialDescription()));
            }
            case "ImportState": {
                return Optional.ofNullable(clazz.cast(this.importStateAsString()));
            }
            case "KeyMaterialState": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialStateAsString()));
            }
            case "ExpirationModel": {
                return Optional.ofNullable(clazz.cast(this.expirationModelAsString()));
            }
            case "ValidTo": {
                return Optional.ofNullable(clazz.cast(this.validTo()));
            }
            case "RotationDate": {
                return Optional.ofNullable(clazz.cast(this.rotationDate()));
            }
            case "RotationType": {
                return Optional.ofNullable(clazz.cast(this.rotationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("KeyMaterialId", KEY_MATERIAL_ID_FIELD);
        map.put("KeyMaterialDescription", KEY_MATERIAL_DESCRIPTION_FIELD);
        map.put("ImportState", IMPORT_STATE_FIELD);
        map.put("KeyMaterialState", KEY_MATERIAL_STATE_FIELD);
        map.put("ExpirationModel", EXPIRATION_MODEL_FIELD);
        map.put("ValidTo", VALID_TO_FIELD);
        map.put("RotationDate", ROTATION_DATE_FIELD);
        map.put("RotationType", ROTATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotationsListEntry, T> g) {
        return obj -> g.apply((RotationsListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String keyMaterialId;
        private String keyMaterialDescription;
        private String importState;
        private String keyMaterialState;
        private String expirationModel;
        private Instant validTo;
        private Instant rotationDate;
        private String rotationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationsListEntry model) {
            this.keyId(model.keyId);
            this.keyMaterialId(model.keyMaterialId);
            this.keyMaterialDescription(model.keyMaterialDescription);
            this.importState(model.importState);
            this.keyMaterialState(model.keyMaterialState);
            this.expirationModel(model.expirationModel);
            this.validTo(model.validTo);
            this.rotationDate(model.rotationDate);
            this.rotationType(model.rotationType);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyMaterialId() {
            return this.keyMaterialId;
        }

        public final void setKeyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
        }

        @Override
        public final Builder keyMaterialId(String keyMaterialId) {
            this.keyMaterialId = keyMaterialId;
            return this;
        }

        public final String getKeyMaterialDescription() {
            return this.keyMaterialDescription;
        }

        public final void setKeyMaterialDescription(String keyMaterialDescription) {
            this.keyMaterialDescription = keyMaterialDescription;
        }

        @Override
        public final Builder keyMaterialDescription(String keyMaterialDescription) {
            this.keyMaterialDescription = keyMaterialDescription;
            return this;
        }

        public final String getImportState() {
            return this.importState;
        }

        public final void setImportState(String importState) {
            this.importState = importState;
        }

        @Override
        public final Builder importState(String importState) {
            this.importState = importState;
            return this;
        }

        @Override
        public final Builder importState(ImportState importState) {
            this.importState(importState == null ? null : importState.toString());
            return this;
        }

        public final String getKeyMaterialState() {
            return this.keyMaterialState;
        }

        public final void setKeyMaterialState(String keyMaterialState) {
            this.keyMaterialState = keyMaterialState;
        }

        @Override
        public final Builder keyMaterialState(String keyMaterialState) {
            this.keyMaterialState = keyMaterialState;
            return this;
        }

        @Override
        public final Builder keyMaterialState(KeyMaterialState keyMaterialState) {
            this.keyMaterialState(keyMaterialState == null ? null : keyMaterialState.toString());
            return this;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel == null ? null : expirationModel.toString());
            return this;
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final Instant getRotationDate() {
            return this.rotationDate;
        }

        public final void setRotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
        }

        @Override
        public final Builder rotationDate(Instant rotationDate) {
            this.rotationDate = rotationDate;
            return this;
        }

        public final String getRotationType() {
            return this.rotationType;
        }

        public final void setRotationType(String rotationType) {
            this.rotationType = rotationType;
        }

        @Override
        public final Builder rotationType(String rotationType) {
            this.rotationType = rotationType;
            return this;
        }

        @Override
        public final Builder rotationType(RotationType rotationType) {
            this.rotationType(rotationType == null ? null : rotationType.toString());
            return this;
        }

        public RotationsListEntry build() {
            return new RotationsListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RotationsListEntry> {
        public Builder keyId(String var1);

        public Builder keyMaterialId(String var1);

        public Builder keyMaterialDescription(String var1);

        public Builder importState(String var1);

        public Builder importState(ImportState var1);

        public Builder keyMaterialState(String var1);

        public Builder keyMaterialState(KeyMaterialState var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);

        public Builder validTo(Instant var1);

        public Builder rotationDate(Instant var1);

        public Builder rotationType(String var1);

        public Builder rotationType(RotationType var1);
    }
}

