/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.ManagedIdentityServiceCredential;
import com.azure.identity.implementation.IdentityClient;
import reactor.core.publisher.Mono;

class AksExchangeTokenCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AksExchangeTokenCredential.class);

    AksExchangeTokenCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE AKS TOKEN EXCHANGE");
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        if (this.getClientId() == null) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("The client id is not configured via 'AZURE_CLIENT_ID' environment variable or through the credential builder. Please ensure client id is provided to authenticate via token exchange in AKS environment.")));
        }
        return this.identityClient.authenticateWithAksConfidentialClient(request);
    }
}

