/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.CovariantTypes;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

class InvariantTypes {
    private InvariantTypes() {
    }

    static boolean isAssignableFrom(Type type1, Type type2) {
        if (type1 instanceof WildcardType || type2 instanceof WildcardType) {
            return CovariantTypes.isAssignableFrom(type1, type2);
        }
        if (type1 instanceof Class) {
            if (type2 instanceof Class) {
                return InvariantTypes.isAssignableFrom((Class)type1, (Class)type2);
            }
            if (TypeCachePollutionUtils.isParameterizedType(type2)) {
                return InvariantTypes.isAssignableFrom((Class)type1, TypeCachePollutionUtils.asParameterizedType(type2));
            }
            if (type2 instanceof TypeVariable) {
                return InvariantTypes.isAssignableFrom((Class)type1, (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return InvariantTypes.isAssignableFrom((Class)type1, (GenericArrayType)type2);
            }
            throw InvariantTypes.unknownType(type2);
        }
        if (TypeCachePollutionUtils.isParameterizedType(type1)) {
            if (type2 instanceof Class) {
                return InvariantTypes.isAssignableFrom(TypeCachePollutionUtils.asParameterizedType(type1), (Class)type2);
            }
            if (type2 instanceof ParameterizedType) {
                return InvariantTypes.isAssignableFrom(TypeCachePollutionUtils.asParameterizedType(type1), TypeCachePollutionUtils.asParameterizedType(type2));
            }
            if (type2 instanceof TypeVariable) {
                return InvariantTypes.isAssignableFrom(TypeCachePollutionUtils.asParameterizedType(type1), (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return InvariantTypes.isAssignableFrom(TypeCachePollutionUtils.asParameterizedType(type1), (GenericArrayType)type2);
            }
            throw InvariantTypes.unknownType(type2);
        }
        if (type1 instanceof TypeVariable) {
            if (type2 instanceof Class) {
                return InvariantTypes.isAssignableFrom((TypeVariable)type1, (Class)type2);
            }
            if (TypeCachePollutionUtils.isParameterizedType(type2)) {
                return InvariantTypes.isAssignableFrom((TypeVariable)type1, TypeCachePollutionUtils.asParameterizedType(type2));
            }
            if (type2 instanceof TypeVariable) {
                return InvariantTypes.isAssignableFrom((TypeVariable)type1, (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return InvariantTypes.isAssignableFrom((TypeVariable)type1, (GenericArrayType)type2);
            }
            throw InvariantTypes.unknownType(type2);
        }
        if (type1 instanceof GenericArrayType) {
            if (type2 instanceof Class) {
                return InvariantTypes.isAssignableFrom((GenericArrayType)type1, (Class)type2);
            }
            if (TypeCachePollutionUtils.isParameterizedType(type2)) {
                return InvariantTypes.isAssignableFrom((GenericArrayType)type1, TypeCachePollutionUtils.asParameterizedType(type2));
            }
            if (type2 instanceof TypeVariable) {
                return InvariantTypes.isAssignableFrom((GenericArrayType)type1, (TypeVariable)type2);
            }
            if (type2 instanceof GenericArrayType) {
                return InvariantTypes.isAssignableFrom((GenericArrayType)type1, (GenericArrayType)type2);
            }
            throw InvariantTypes.unknownType(type2);
        }
        throw InvariantTypes.unknownType(type1);
    }

    static IllegalArgumentException unknownType(Type type) {
        return new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }

    private static boolean isAssignableFrom(Class<?> type1, Class<?> type2) {
        return Types.boxedClass(type1).equals(Types.boxedClass(type2));
    }

    private static boolean isAssignableFrom(Class<?> type1, ParameterizedType type2) {
        return false;
    }

    private static boolean isAssignableFrom(Class<?> type1, TypeVariable<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(Class<?> type1, GenericArrayType type2) {
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, Class<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, ParameterizedType type2) {
        Type[] types2;
        if (!Types.getRawType(type1).equals(Types.getRawType(type2))) {
            return false;
        }
        Type[] types1 = type1.getActualTypeArguments();
        if (types1.length != (types2 = type2.getActualTypeArguments()).length) {
            throw new IllegalArgumentException("Invalida argument combination: " + String.valueOf(type1) + " and " + String.valueOf(type2));
        }
        for (int i = 0; i < types1.length; ++i) {
            if (InvariantTypes.isAssignableFrom(types1[i], types2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, TypeVariable<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(ParameterizedType type1, GenericArrayType type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, Class<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, ParameterizedType type2) {
        return false;
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, TypeVariable<?> type2) {
        return type1.equals(type2);
    }

    private static boolean isAssignableFrom(TypeVariable<?> type1, GenericArrayType type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, Class<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, ParameterizedType type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, TypeVariable<?> type2) {
        return false;
    }

    private static boolean isAssignableFrom(GenericArrayType type1, GenericArrayType type2) {
        return InvariantTypes.isAssignableFrom(type1.getGenericComponentType(), type2.getGenericComponentType());
    }
}

