/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.context.SmallRyeManagedExecutor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisAuthorizerImpl;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactoryImpl;
import org.apache.polaris.core.persistence.resolver.Resolver;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.core.storage.cache.StorageCredentialCacheConfig;
import org.apache.polaris.service.auth.AuthenticationConfiguration;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.AuthenticationType;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.external.OidcConfiguration;
import org.apache.polaris.service.auth.external.tenant.OidcTenantResolver;
import org.apache.polaris.service.auth.internal.broker.TokenBroker;
import org.apache.polaris.service.auth.internal.broker.TokenBrokerFactory;
import org.apache.polaris.service.catalog.api.IcebergRestOAuth2ApiService;
import org.apache.polaris.service.catalog.io.FileIOConfiguration;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.context.RealmContextConfiguration;
import org.apache.polaris.service.context.RealmContextResolver;
import org.apache.polaris.service.events.PolarisEventListenerConfiguration;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.persistence.PersistenceConfiguration;
import org.apache.polaris.service.ratelimiter.RateLimiter;
import org.apache.polaris.service.ratelimiter.RateLimiterFilterConfiguration;
import org.apache.polaris.service.ratelimiter.TokenBucketConfiguration;
import org.apache.polaris.service.ratelimiter.TokenBucketFactory;
import org.apache.polaris.service.secrets.SecretsManagerConfiguration;
import org.apache.polaris.service.storage.StorageConfiguration;
import org.apache.polaris.service.storage.aws.S3AccessConfig;
import org.apache.polaris.service.storage.aws.StsClientsPool;
import org.apache.polaris.service.task.TaskHandlerConfiguration;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;

public class ServiceProducers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceProducers.class);

    @Produces
    @ApplicationScoped
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Produces
    @ApplicationScoped
    public StorageCredentialCache storageCredentialCache(PolarisDiagnostics diagnostics, StorageCredentialCacheConfig storageCredentialCacheConfig) {
        return new StorageCredentialCache(diagnostics, storageCredentialCacheConfig);
    }

    @Produces
    @Singleton
    public PolarisDiagnostics polarisDiagnostics() {
        return new PolarisDefaultDiagServiceImpl();
    }

    @Produces
    @RequestScoped
    public RealmContext realmContext(@Context ContainerRequestContext request) {
        return (RealmContext)request.getProperty("realmContext");
    }

    @Produces
    @RequestScoped
    public CallContext polarisCallContext(RealmContext realmContext, PolarisConfigurationStore configurationStore, MetaStoreManagerFactory metaStoreManagerFactory) {
        BasePersistence metaStoreSession = metaStoreManagerFactory.getOrCreateSession(realmContext);
        return new PolarisCallContext(realmContext, metaStoreSession, configurationStore);
    }

    @Produces
    @RequestScoped
    public RealmConfig realmConfig(CallContext callContext) {
        return callContext.getRealmConfig();
    }

    @Produces
    @RequestScoped
    public PolarisAuthorizer polarisAuthorizer(RealmConfig realmConfig) {
        return new PolarisAuthorizerImpl(realmConfig);
    }

    @Produces
    @RequestScoped
    public ResolverFactory resolverFactory(PolarisDiagnostics diagnostics, RealmContext realmContext, RealmConfig realmConfig, MetaStoreManagerFactory metaStoreManagerFactory, CallContext callContext, PolarisMetaStoreManager polarisMetaStoreManager) {
        EntityCache entityCache = metaStoreManagerFactory.getOrCreateEntityCache(realmContext, realmConfig);
        return (securityContext, referenceCatalogName) -> new Resolver(diagnostics, callContext.getPolarisCallContext(), polarisMetaStoreManager, securityContext, entityCache, referenceCatalogName);
    }

    @Produces
    @RequestScoped
    public ResolutionManifestFactory resolutionManifestFactory(PolarisDiagnostics diagnostics, RealmContext realmContext, ResolverFactory resolverFactory) {
        return new ResolutionManifestFactoryImpl(diagnostics, realmContext, resolverFactory);
    }

    @Produces
    public RealmContextResolver realmContextResolver(RealmContextConfiguration config, @Any Instance<RealmContextResolver> realmContextResolvers) {
        return (RealmContextResolver)realmContextResolvers.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public FileIOFactory fileIOFactory(FileIOConfiguration config, @Any Instance<FileIOFactory> fileIOFactories) {
        return (FileIOFactory)fileIOFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public PolarisEventListener polarisEventListener(PolarisEventListenerConfiguration config, @Any Instance<PolarisEventListener> polarisEventListeners) {
        return (PolarisEventListener)polarisEventListeners.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public MetaStoreManagerFactory metaStoreManagerFactory(PersistenceConfiguration config, @Any Instance<MetaStoreManagerFactory> metaStoreManagerFactories) {
        return (MetaStoreManagerFactory)metaStoreManagerFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    @RequestScoped
    public PolarisMetaStoreManager polarisMetaStoreManager(RealmContext realmContext, MetaStoreManagerFactory metaStoreManagerFactory) {
        return metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
    }

    @Produces
    public UserSecretsManagerFactory userSecretsManagerFactory(SecretsManagerConfiguration config, @Any Instance<UserSecretsManagerFactory> userSecretsManagerFactories) {
        return (UserSecretsManagerFactory)userSecretsManagerFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    @Singleton
    @Identifier(value="aws-sdk-http-client")
    public SdkHttpClient sdkHttpClient(S3AccessConfig config) {
        ApacheHttpClient.Builder httpClient = ApacheHttpClient.builder();
        config.maxHttpConnections().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).maxConnections(arg_0));
        config.readTimeout().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).socketTimeout(arg_0));
        config.connectTimeout().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).connectionTimeout(arg_0));
        config.connectionAcquisitionTimeout().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).connectionAcquisitionTimeout(arg_0));
        config.connectionMaxIdleTime().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).connectionMaxIdleTime(arg_0));
        config.connectionTimeToLive().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).connectionTimeToLive(arg_0));
        config.expectContinueEnabled().ifPresent(arg_0 -> ((ApacheHttpClient.Builder)httpClient).expectContinueEnabled(arg_0));
        return httpClient.build();
    }

    public void closeSdkHttpClient(@Disposes @Identifier(value="aws-sdk-http-client") SdkHttpClient client) {
        client.close();
    }

    @Produces
    @ApplicationScoped
    public StsClientsPool stsClientsPool(@Identifier(value="aws-sdk-http-client") SdkHttpClient httpClient, StorageConfiguration config, MeterRegistry meterRegistry) {
        return new StsClientsPool(config.effectiveClientsCacheMaxSize(), httpClient, meterRegistry);
    }

    public void maybeBootstrap(@Observes Startup event, MetaStoreManagerFactory factory, PersistenceConfiguration config, RealmContextConfiguration realmContextConfiguration) {
        RootCredentialsSet rootCredentialsSet = RootCredentialsSet.fromEnvironment();
        Map rootCredentials = rootCredentialsSet.credentials();
        if (config.isAutoBootstrap()) {
            List<String> realmIds = realmContextConfiguration.realms();
            LOGGER.info("Bootstrapping realm(s) {}, if necessary, from root credentials set provided via the environment variable {} or Java system property {} ...", new Object[]{realmIds.stream().map(r -> "'" + r + "'").collect(Collectors.joining(", ")), "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
            Map result = factory.bootstrapRealms(realmIds, rootCredentialsSet);
            result.forEach((realm, secrets) -> {
                PolarisPrincipalSecrets principalSecrets = secrets.getPrincipalSecrets();
                LoggingEventBuilder log = LOGGER.atInfo().addArgument(realm).addArgument((Object)"POLARIS_BOOTSTRAP_CREDENTIALS").addArgument((Object)"polaris.bootstrap.credentials");
                if (rootCredentials.containsKey(realm)) {
                    log.log("Realm '{}' automatically bootstrapped, credentials taken from root credentials set provided via the environment variable {} or Java system property {}, not printed to stdout.");
                } else {
                    log.log("Realm '{}' automatically bootstrapped, credentials were not present in root credentials set provided via the environment variable {} or Java system property {}, see separate message printed to stdout.");
                    String msg = String.format("realm: %1s root principal credentials: %2s:%3s", realm, principalSecrets.getPrincipalClientId(), principalSecrets.getMainSecret());
                    System.out.println(msg);
                }
            });
            String unusedRealmSecrets = realmIds.stream().filter(rootCredentials::containsKey).filter(r -> !result.containsKey(r)).map(r -> "'" + r + "'").collect(Collectors.joining(", "));
            if (!unusedRealmSecrets.isEmpty()) {
                LOGGER.error("The realms {} are already fully bootstrapped but the secrets are still available via the environment variable {} or Java system property {}. Remove this security sensitive information from the environment / Java system properties!", new Object[]{unusedRealmSecrets, "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
            }
        } else if (!rootCredentials.isEmpty()) {
            LOGGER.error("Secrets for the realms {} are available via the environment variable {} or Java system property {}. Remove this security sensitive information from the environment / Java system properties!", new Object[]{rootCredentials.keySet(), "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
        }
    }

    @Produces
    public RateLimiter rateLimiter(RateLimiterFilterConfiguration config, @Any Instance<RateLimiter> rateLimiters) {
        return (RateLimiter)rateLimiters.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public TokenBucketFactory tokenBucketFactory(TokenBucketConfiguration config, @Any Instance<TokenBucketFactory> tokenBucketFactories) {
        return (TokenBucketFactory)tokenBucketFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    @RequestScoped
    public Authenticator authenticator(AuthenticationRealmConfiguration config, @Any Instance<Authenticator> authenticators) {
        return (Authenticator)authenticators.select(new Annotation[]{Identifier.Literal.of((String)config.authenticator().type())}).get();
    }

    @Produces
    @RequestScoped
    public IcebergRestOAuth2ApiService icebergRestOAuth2ApiService(AuthenticationRealmConfiguration config, @Any Instance<IcebergRestOAuth2ApiService> services) {
        String type = config.type() == AuthenticationType.EXTERNAL ? "disabled" : config.tokenService().type();
        return (IcebergRestOAuth2ApiService)services.select(new Annotation[]{Identifier.Literal.of((String)type)}).get();
    }

    @Produces
    @RequestScoped
    public TokenBroker tokenBroker(AuthenticationRealmConfiguration config, RealmContext realmContext, @Any Instance<TokenBrokerFactory> tokenBrokerFactories) {
        String type = config.type() == AuthenticationType.EXTERNAL ? "none" : config.tokenBroker().type();
        TokenBrokerFactory tokenBrokerFactory = (TokenBrokerFactory)tokenBrokerFactories.select(new Annotation[]{Identifier.Literal.of((String)type)}).get();
        return (TokenBroker)tokenBrokerFactory.apply(realmContext);
    }

    @Produces
    @Singleton
    @Identifier(value="task-executor")
    public ManagedExecutor taskExecutor(TaskHandlerConfiguration config) {
        return SmallRyeManagedExecutor.builder().injectionPointName("task-executor").propagated(new String[]{"Remaining"}).maxAsync(config.maxConcurrentTasks()).maxQueued(config.maxQueuedTasks()).build();
    }

    @Produces
    @RequestScoped
    public UserSecretsManager userSecretsManager(RealmContext realmContext, UserSecretsManagerFactory userSecretsManagerFactory) {
        return userSecretsManagerFactory.getOrCreateUserSecretsManager(realmContext);
    }

    @Produces
    @RequestScoped
    public AuthenticationRealmConfiguration realmAuthConfig(AuthenticationConfiguration config, RealmContext realmContext) {
        return config.forRealm(realmContext);
    }

    @Produces
    public OidcTenantResolver oidcTenantResolver(OidcConfiguration config, @Any Instance<OidcTenantResolver> resolvers) {
        return (OidcTenantResolver)resolvers.select(new Annotation[]{Identifier.Literal.of((String)config.tenantResolver())}).get();
    }

    public void closeTaskExecutor(@Disposes @Identifier(value="task-executor") ManagedExecutor executor) {
        executor.close();
    }
}

