/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.broker;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.polaris.service.auth.internal.broker.TokenResponse;
import org.apache.polaris.service.auth.internal.service.OAuthError;
import org.immutables.value.Generated;

@Generated(from="TokenResponse", generator="Immutables")
public final class ImmutableTokenResponse
implements TokenResponse {
    @Nullable
    private final OAuthError error;
    @Nullable
    private final String accessToken;
    private final int expiresIn;
    @Nullable
    private final String tokenType;
    private transient int hashCode;

    private ImmutableTokenResponse(Builder builder) {
        this.error = builder.error;
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresInIsSet() ? builder.expiresIn : TokenResponse.super.getExpiresIn();
    }

    private ImmutableTokenResponse(@Nullable OAuthError error, @Nullable String accessToken, int expiresIn, @Nullable String tokenType) {
        this.error = error;
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.tokenType = tokenType;
    }

    @Override
    @Nullable
    public OAuthError getError() {
        return this.error;
    }

    @Override
    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public int getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    @Nullable
    public String getTokenType() {
        return this.tokenType;
    }

    public final ImmutableTokenResponse withError(@Nullable OAuthError value) {
        if (this.error == value) {
            return this;
        }
        return new ImmutableTokenResponse(value, this.accessToken, this.expiresIn, this.tokenType);
    }

    public final ImmutableTokenResponse withAccessToken(@Nullable String value) {
        if (Objects.equals(this.accessToken, value)) {
            return this;
        }
        return new ImmutableTokenResponse(this.error, value, this.expiresIn, this.tokenType);
    }

    public final ImmutableTokenResponse withExpiresIn(int value) {
        if (this.expiresIn == value) {
            return this;
        }
        return new ImmutableTokenResponse(this.error, this.accessToken, value, this.tokenType);
    }

    public final ImmutableTokenResponse withTokenType(@Nullable String value) {
        if (Objects.equals(this.tokenType, value)) {
            return this;
        }
        return new ImmutableTokenResponse(this.error, this.accessToken, this.expiresIn, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenResponse && this.equalsByValue((ImmutableTokenResponse)another);
    }

    private boolean equalsByValue(ImmutableTokenResponse another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals((Object)this.error, (Object)another.error) && Objects.equals(this.accessToken, another.accessToken) && this.expiresIn == another.expiresIn && Objects.equals(this.tokenType, another.tokenType);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.error);
        h += (h << 5) + Objects.hashCode(this.accessToken);
        h += (h << 5) + this.expiresIn;
        h += (h << 5) + Objects.hashCode(this.tokenType);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TokenResponse").omitNullValues().add("error", (Object)this.error).add("accessToken", (Object)this.accessToken).add("expiresIn", this.expiresIn).add("tokenType", (Object)this.tokenType).toString();
    }

    public static ImmutableTokenResponse copyOf(TokenResponse instance) {
        if (instance instanceof ImmutableTokenResponse) {
            return (ImmutableTokenResponse)instance;
        }
        return ImmutableTokenResponse.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableTokenResponse.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokenResponse", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_EXPIRES_IN = 1L;
        private long optBits;
        private OAuthError error;
        private String accessToken;
        private int expiresIn;
        private String tokenType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenResponse instance) {
            String accessTokenValue;
            Objects.requireNonNull(instance, "instance");
            OAuthError errorValue = instance.getError();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((accessTokenValue = instance.getAccessToken()) != null) {
                this.accessToken(accessTokenValue);
            }
            this.expiresIn(instance.getExpiresIn());
            String tokenTypeValue = instance.getTokenType();
            if (tokenTypeValue != null) {
                this.tokenType(tokenTypeValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(@Nullable OAuthError error) {
            this.error = error;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessToken(@Nullable String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenType(@Nullable String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.optBits = 0L;
            this.error = null;
            this.accessToken = null;
            this.expiresIn = 0;
            this.tokenType = null;
            return this;
        }

        public ImmutableTokenResponse build() {
            return new ImmutableTokenResponse(this);
        }

        private boolean expiresInIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

