/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import javax.annotation.Nullable;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.ImmutableScanMetricsResult;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.TimerResult;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public interface ScanMetricsResult {
    @Nullable
    public TimerResult totalPlanningDuration();

    @Nullable
    public CounterResult resultDataFiles();

    @Nullable
    public CounterResult resultDeleteFiles();

    @Nullable
    public CounterResult totalDataManifests();

    @Nullable
    public CounterResult totalDeleteManifests();

    @Nullable
    public CounterResult scannedDataManifests();

    @Nullable
    public CounterResult skippedDataManifests();

    @Nullable
    public CounterResult totalFileSizeInBytes();

    @Nullable
    public CounterResult totalDeleteFileSizeInBytes();

    @Nullable
    public CounterResult skippedDataFiles();

    @Nullable
    public CounterResult skippedDeleteFiles();

    @Nullable
    public CounterResult scannedDeleteManifests();

    @Nullable
    public CounterResult skippedDeleteManifests();

    @Nullable
    public CounterResult indexedDeleteFiles();

    @Nullable
    public CounterResult equalityDeleteFiles();

    @Nullable
    public CounterResult positionalDeleteFiles();

    @Nullable
    @Value.Default
    default public CounterResult dvs() {
        return null;
    }

    public static ScanMetricsResult fromScanMetrics(ScanMetrics scanMetrics) {
        Preconditions.checkArgument((null != scanMetrics ? 1 : 0) != 0, (Object)"Invalid scan metrics: null");
        return ImmutableScanMetricsResult.builder().totalPlanningDuration(TimerResult.fromTimer(scanMetrics.totalPlanningDuration())).resultDataFiles(CounterResult.fromCounter(scanMetrics.resultDataFiles())).resultDeleteFiles(CounterResult.fromCounter(scanMetrics.resultDeleteFiles())).totalDataManifests(CounterResult.fromCounter(scanMetrics.totalDataManifests())).totalDeleteManifests(CounterResult.fromCounter(scanMetrics.totalDeleteManifests())).scannedDataManifests(CounterResult.fromCounter(scanMetrics.scannedDataManifests())).skippedDataManifests(CounterResult.fromCounter(scanMetrics.skippedDataManifests())).totalFileSizeInBytes(CounterResult.fromCounter(scanMetrics.totalFileSizeInBytes())).totalDeleteFileSizeInBytes(CounterResult.fromCounter(scanMetrics.totalDeleteFileSizeInBytes())).skippedDataFiles(CounterResult.fromCounter(scanMetrics.skippedDataFiles())).skippedDeleteFiles(CounterResult.fromCounter(scanMetrics.skippedDeleteFiles())).scannedDeleteManifests(CounterResult.fromCounter(scanMetrics.scannedDeleteManifests())).skippedDeleteManifests(CounterResult.fromCounter(scanMetrics.skippedDeleteManifests())).indexedDeleteFiles(CounterResult.fromCounter(scanMetrics.indexedDeleteFiles())).equalityDeleteFiles(CounterResult.fromCounter(scanMetrics.equalityDeleteFiles())).positionalDeleteFiles(CounterResult.fromCounter(scanMetrics.positionalDeleteFiles())).dvs(CounterResult.fromCounter(scanMetrics.dvs())).build();
    }
}

