/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import org.jboss.logmanager.handlers.ClientSocketFactory;

public class TcpOutputStream
extends OutputStream
implements AutoCloseable,
Flushable {
    private static final long retryTimeout = 5L;
    private static final long maxRetryTimeout = 40L;
    private static final int maxErrors = 10;
    protected final ReentrantLock outputLock = new ReentrantLock();
    private final ClientSocketFactory socketFactory;
    private final Deque<Exception> errors = new ArrayDeque<Exception>(10);
    private Thread reconnectThread;
    private boolean blockOnReconnect;
    private Socket socket;
    private boolean connected;

    public TcpOutputStream(InetAddress address, int port) throws IOException {
        this(SocketFactory.getDefault(), address, port);
    }

    public TcpOutputStream(InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this(SocketFactory.getDefault(), address, port, blockOnReconnect);
    }

    @Deprecated
    protected TcpOutputStream(Socket socket) {
        this.socketFactory = null;
        this.socket = socket;
        this.reconnectThread = null;
        this.connected = true;
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port) throws IOException {
        this(socketFactory, address, port, false);
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this(ClientSocketFactory.of(socketFactory, address, port), blockOnReconnect);
    }

    public TcpOutputStream(ClientSocketFactory socketFactory, boolean blockOnReconnect) {
        this.socketFactory = socketFactory;
        this.blockOnReconnect = blockOnReconnect;
        try {
            this.socket = this.socketFactory.createSocket();
            this.connected = true;
        }
        catch (IOException e) {
            this.connected = false;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block9: {
            this.outputLock.lock();
            try {
                this.checkReconnect();
                if (this.connected) {
                    this.socket.getOutputStream().write(b, off, len);
                }
            }
            catch (SocketException e) {
                if (this.isReconnectAllowed()) {
                    TcpOutputStream.safeClose(this.socket);
                    this.connected = false;
                    this.addError(e);
                    this.reconnectThread = this.createThread();
                    if (this.blockOnReconnect) {
                        this.reconnectThread.run();
                        this.write(b, off, len);
                    } else {
                        this.reconnectThread.start();
                    }
                    break block9;
                }
                throw e;
            }
            finally {
                this.outputLock.unlock();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        block7: {
            this.outputLock.lock();
            try {
                if (this.socket != null) {
                    this.socket.getOutputStream().flush();
                }
            }
            catch (SocketException e) {
                if (this.isReconnectAllowed()) {
                    TcpOutputStream.safeClose(this.socket);
                    this.connected = false;
                    this.addError(e);
                    break block7;
                }
                throw e;
            }
            finally {
                this.outputLock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.outputLock.lock();
        try {
            if (this.reconnectThread != null) {
                this.reconnectThread.interrupt();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        finally {
            this.outputLock.unlock();
        }
    }

    public boolean isBlockOnReconnect() {
        this.outputLock.lock();
        try {
            boolean bl = this.blockOnReconnect;
            return bl;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    public void setBlockOnReconnect(boolean blockOnReconnect) {
        this.outputLock.lock();
        try {
            this.blockOnReconnect = blockOnReconnect;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    public boolean isConnected() {
        this.outputLock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.outputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Exception> getErrors() {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (!this.errors.isEmpty()) {
                ArrayList<Exception> result = new ArrayList<Exception>(this.errors);
                this.errors.clear();
                return result;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(Exception e) {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (this.errors.size() < 10) {
                this.errors.addLast(e);
            }
        }
    }

    private boolean isReconnectAllowed() {
        return this.socketFactory != null && this.reconnectThread == null;
    }

    private void checkReconnect() {
        if (!this.connected && this.isReconnectAllowed()) {
            this.reconnectThread = this.createThread();
            if (this.blockOnReconnect) {
                this.reconnectThread.run();
            } else {
                this.reconnectThread.start();
            }
        }
    }

    private Thread createThread() {
        Thread thread = new Thread(new RetryConnector());
        thread.setDaemon(true);
        thread.setName("LogManager Socket Reconnect Thread");
        return thread;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class RetryConnector
    implements Runnable {
        private int attempts = 0;

        private RetryConnector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean connected = false;
            while (TcpOutputStream.this.socketFactory != null && !connected) {
                Socket socket = null;
                try {
                    socket = TcpOutputStream.this.socketFactory.createSocket();
                    TcpOutputStream.this.outputLock.lock();
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            TcpOutputStream.safeClose(socket);
                            break;
                        }
                        TcpOutputStream.this.socket = socket;
                        TcpOutputStream.this.connected = true;
                        TcpOutputStream.this.reconnectThread = null;
                        connected = true;
                    }
                    finally {
                        TcpOutputStream.this.outputLock.unlock();
                    }
                }
                catch (IOException e) {
                    connected = false;
                    TcpOutputStream.this.addError(e);
                    long timeout = (long)this.attempts++ > 0L ? 10L * (long)this.attempts : 5L;
                    try {
                        TimeUnit.SECONDS.sleep(Math.min(timeout, 40L));
                    }
                    catch (InterruptedException ignore) {
                        TcpOutputStream.this.outputLock.lock();
                        try {
                            TcpOutputStream.this.connected = false;
                            break;
                        }
                        finally {
                            TcpOutputStream.this.outputLock.unlock();
                        }
                    }
                }
                finally {
                    if (connected) continue;
                    TcpOutputStream.safeClose(socket);
                }
            }
        }
    }
}

