/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.sas;

import com.azure.core.util.Configuration;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.sas.FileSystemSasPermission;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import java.time.OffsetDateTime;

public final class DataLakeServiceSasSignatureValues {
    private static final String VERSION = (String)Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", (Object)DataLakeServiceVersion.getLatest().getVersion());
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private String preauthorizedAgentObjectId;
    private String agentObjectId;
    private String correlationId;
    private String encryptionScope;

    public DataLakeServiceSasSignatureValues(OffsetDateTime expiryTime, FileSystemSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public DataLakeServiceSasSignatureValues(OffsetDateTime expiryTime, PathSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public DataLakeServiceSasSignatureValues(String identifier) {
        StorageImplUtils.assertNotNull((String)"identifier", (Object)identifier);
        this.identifier = identifier;
    }

    public String getVersion() {
        return VERSION;
    }

    @Deprecated
    public DataLakeServiceSasSignatureValues setVersion(String version) {
        return this;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public DataLakeServiceSasSignatureValues setProtocol(SasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public DataLakeServiceSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public DataLakeServiceSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public DataLakeServiceSasSignatureValues setPermissions(PathSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public DataLakeServiceSasSignatureValues setPermissions(FileSystemSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public DataLakeServiceSasSignatureValues setSasIpRange(SasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public DataLakeServiceSasSignatureValues setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public DataLakeServiceSasSignatureValues setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public DataLakeServiceSasSignatureValues setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public DataLakeServiceSasSignatureValues setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public DataLakeServiceSasSignatureValues setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public DataLakeServiceSasSignatureValues setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getPreauthorizedAgentObjectId() {
        return this.preauthorizedAgentObjectId;
    }

    public DataLakeServiceSasSignatureValues setPreauthorizedAgentObjectId(String preauthorizedAgentObjectId) {
        this.preauthorizedAgentObjectId = preauthorizedAgentObjectId;
        return this;
    }

    public String getAgentObjectId() {
        return this.agentObjectId;
    }

    public DataLakeServiceSasSignatureValues setAgentObjectId(String agentObjectId) {
        this.agentObjectId = agentObjectId;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public DataLakeServiceSasSignatureValues setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public DataLakeServiceSasSignatureValues setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }
}

