/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.BaseSubscriberAdapter;
import software.amazon.awssdk.utils.async.DemandIgnoringSubscription;
import software.amazon.awssdk.utils.async.StoringSubscriber;

@SdkProtectedApi
public class DelegatingBufferingSubscriber
extends BaseSubscriberAdapter<ByteBuffer, ByteBuffer> {
    private static final Logger log = Logger.loggerFor(DelegatingBufferingSubscriber.class);
    private final long maximumBufferInBytes;
    private final AtomicLong currentlyBuffered = new AtomicLong(0L);
    private final StoringSubscriber<ByteBuffer> storage = new StoringSubscriber(Integer.MAX_VALUE);

    protected DelegatingBufferingSubscriber(Long maximumBufferInBytes, Subscriber<? super ByteBuffer> delegate) {
        super(Validate.notNull(delegate, "delegate must not be null", new Object[0]));
        this.maximumBufferInBytes = Validate.notNull(maximumBufferInBytes, "maximumBufferInBytes must not be null", new Object[0]);
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.storage.onSubscribe(new DemandIgnoringSubscription(subscription));
        super.onSubscribe(subscription);
    }

    @Override
    void doWithItem(ByteBuffer buffer) {
        this.storage.onNext(buffer.duplicate());
        this.currentlyBuffered.addAndGet(buffer.remaining());
    }

    @Override
    protected void fulfillDownstreamDemand() {
        this.storage.poll().filter(event -> event.type() == StoringSubscriber.EventType.ON_NEXT).ifPresent(byteBufferEvent -> {
            this.currentlyBuffered.addAndGet(-((ByteBuffer)byteBufferEvent.value()).remaining());
            this.downstreamDemand.decrementAndGet();
            log.trace(() -> "demand: " + this.downstreamDemand.get());
            this.subscriber.onNext(byteBufferEvent.value());
        });
    }

    @Override
    boolean additionalOnNextNeededCheck() {
        return this.storage.peek().map(event -> event.type() == StoringSubscriber.EventType.ON_NEXT).orElse(false);
    }

    @Override
    boolean additionalOnCompleteNeededCheck() {
        return this.storage.peek().map(event -> event.type() == StoringSubscriber.EventType.ON_COMPLETE).orElse(true);
    }

    @Override
    boolean additionalUpstreamDemandNeededCheck() {
        return this.currentlyBuffered.get() < this.maximumBufferInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long maximumBufferInBytes;
        private Subscriber<? super ByteBuffer> delegate;

        public Builder maximumBufferInBytes(Long maximumBufferInBytes) {
            this.maximumBufferInBytes = maximumBufferInBytes;
            return this;
        }

        public Builder delegate(Subscriber<? super ByteBuffer> delegate) {
            this.delegate = delegate;
            return this;
        }

        public DelegatingBufferingSubscriber build() {
            return new DelegatingBufferingSubscriber(this.maximumBufferInBytes, this.delegate);
        }
    }
}

