/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OCSFVersion {
    V1_1("V1.1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OCSFVersion> VALUE_MAP;
    private final String value;

    private OCSFVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OCSFVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OCSFVersion> knownValues() {
        EnumSet<OCSFVersion> knownValues = EnumSet.allOf(OCSFVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OCSFVersion.class, OCSFVersion::toString);
    }
}

