/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.resolver;

import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.resolver.ResolverPath;

public class ResolverStatus {
    private final StatusEnum status;
    private final PolarisEntityType failedToResolvedEntityType;
    private final String failedToResolvedEntityName;
    private final ResolverPath failedToResolvePath;
    private final int failedToResolvedEntityIndex;

    public ResolverStatus(StatusEnum status) {
        this.status = status;
        this.failedToResolvedEntityType = null;
        this.failedToResolvedEntityName = null;
        this.failedToResolvePath = null;
        this.failedToResolvedEntityIndex = 0;
    }

    public ResolverStatus(PolarisEntityType failedToResolvedEntityType, String failedToResolvedEntityName) {
        this.status = StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED;
        this.failedToResolvedEntityType = failedToResolvedEntityType;
        this.failedToResolvedEntityName = failedToResolvedEntityName;
        this.failedToResolvePath = null;
        this.failedToResolvedEntityIndex = 0;
    }

    public ResolverStatus(ResolverPath failedToResolvePath, int failedToResolvedEntityIndex) {
        this.status = StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED;
        this.failedToResolvedEntityType = null;
        this.failedToResolvedEntityName = null;
        this.failedToResolvePath = failedToResolvePath;
        this.failedToResolvedEntityIndex = failedToResolvedEntityIndex;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public PolarisEntityType getFailedToResolvedEntityType() {
        return this.failedToResolvedEntityType;
    }

    public String getFailedToResolvedEntityName() {
        return this.failedToResolvedEntityName;
    }

    public ResolverPath getFailedToResolvePath() {
        return this.failedToResolvePath;
    }

    public int getFailedToResolvedEntityIndex() {
        return this.failedToResolvedEntityIndex;
    }

    public static enum StatusEnum {
        SUCCESS,
        CALLER_PRINCIPAL_DOES_NOT_EXIST,
        PATH_COULD_NOT_BE_FULLY_RESOLVED,
        ENTITY_COULD_NOT_BE_RESOLVED;

    }
}

