/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.polaris.core.storage.aws.S3Location;
import org.apache.polaris.core.storage.azure.AzureLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLocation {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageLocation.class);
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^(.+?):(.+)");
    public static final String LOCAL_PATH_PREFIX = "file:///";
    private final String location;

    public static StorageLocation of(String location) {
        if (AzureLocation.isAzureLocation(location)) {
            return new AzureLocation(location);
        }
        if (S3Location.isS3Location(location)) {
            return new S3Location(location);
        }
        return new StorageLocation(location);
    }

    protected StorageLocation(@Nonnull String location) {
        this.location = location == null ? null : (location.startsWith("file:/") ? URI.create(location.replaceFirst("file:/+", LOCAL_PATH_PREFIX)).toString() : (location.startsWith("/") ? URI.create(location.replaceFirst("/+", LOCAL_PATH_PREFIX)).toString() : location));
    }

    protected static String ensureTrailingSlash(String location) {
        if (location == null || location.endsWith("/")) {
            return location;
        }
        return location + "/";
    }

    @Nonnull
    protected static String ensureLeadingSlash(@Nonnull String location) {
        if (location.startsWith("/")) {
            return location;
        }
        return "/" + location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageLocation) {
            return this.location.equals(((StorageLocation)obj).location);
        }
        return false;
    }

    public String toString() {
        return this.location;
    }

    public boolean isChildOf(StorageLocation potentialParent) {
        if (this.location == null || potentialParent.location == null) {
            return false;
        }
        String slashTerminatedLocation = StorageLocation.ensureTrailingSlash(this.location);
        String slashTerminatedParentLocation = StorageLocation.ensureTrailingSlash(potentialParent.location);
        return slashTerminatedLocation.startsWith(slashTerminatedParentLocation);
    }

    public String withoutScheme() {
        if (this.location == null) {
            return null;
        }
        Matcher matcher = SCHEME_PATTERN.matcher(this.location);
        if (matcher.matches()) {
            String locationWithoutScheme = matcher.group(2);
            LOGGER.debug("Extracted {} from location {}", (Object)locationWithoutScheme, (Object)this.location);
            return locationWithoutScheme;
        }
        LOGGER.debug("Found no scheme in location {}", (Object)this.location);
        return this.location;
    }
}

