/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;

public class LoadPolicyMappingsResult
extends BaseResult {
    private final List<PolarisPolicyMappingRecord> mappingRecords;
    private final List<PolarisBaseEntity> entities;

    public LoadPolicyMappingsResult(@Nonnull BaseResult.ReturnStatus errorCode, @Nullable String extraInformation) {
        super(errorCode, extraInformation);
        this.mappingRecords = null;
        this.entities = null;
    }

    public LoadPolicyMappingsResult(@Nonnull List<PolarisPolicyMappingRecord> mappingRecords, @Nonnull List<PolarisBaseEntity> entities) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.mappingRecords = mappingRecords;
        this.entities = entities;
    }

    @JsonCreator
    private LoadPolicyMappingsResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") String extraInformation, @JsonProperty(value="policyMappingRecords") List<PolarisPolicyMappingRecord> mappingRecords, @JsonProperty(value="policyEntities") List<PolarisBaseEntity> entities) {
        super(returnStatus, extraInformation);
        this.mappingRecords = mappingRecords;
        this.entities = entities;
    }

    public List<PolarisPolicyMappingRecord> getPolicyMappingRecords() {
        return this.mappingRecords;
    }

    public List<PolarisBaseEntity> getEntities() {
        return this.entities;
    }

    @JsonIgnore
    public Map<Long, PolarisBaseEntity> getEntitiesAsMap() {
        return this.entities == null ? null : this.entities.stream().collect(Collectors.toMap(PolarisEntityCore::getId, entity -> entity));
    }

    public String toString() {
        return "LoadPolicyMappingsResult{mappingRecords=" + String.valueOf(this.mappingRecords) + ", entities=" + String.valueOf(this.entities) + "}";
    }
}

