/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.AzureJsonUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Objects;

final class JacksonJsonReader
extends JsonReader {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonJsonReader.class);
    private final JsonParser parser;
    private final byte[] jsonBytes;
    private final String jsonString;
    private final boolean resetSupported;
    private final JsonOptions jsonOptions;
    private JsonToken currentToken;

    JacksonJsonReader(JsonParser parser, byte[] jsonBytes, String jsonString, boolean resetSupported, JsonOptions jsonOptions) {
        this.parser = Objects.requireNonNull(parser, "Cannot create a Jackson-based instance of com.azure.json.JsonReader with a null Jackson JsonParser.");
        this.jsonBytes = jsonBytes;
        this.jsonString = jsonString;
        this.resetSupported = resetSupported;
        this.jsonOptions = jsonOptions;
        this.currentToken = JacksonJsonReader.mapToken(parser.currentToken(), null);
    }

    public JsonToken currentToken() {
        return this.currentToken;
    }

    public JsonToken nextToken() throws IOException {
        this.currentToken = JacksonJsonReader.mapToken(this.parser.nextToken(), this.currentToken);
        return this.currentToken;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public byte[] getBinary() throws IOException {
        if (this.currentToken() == JsonToken.NULL) {
            return null;
        }
        return this.parser.getBinaryValue();
    }

    public boolean getBoolean() throws IOException {
        return this.parser.getBooleanValue();
    }

    public float getFloat() throws IOException {
        return this.parser.getFloatValue();
    }

    public double getDouble() throws IOException {
        return this.parser.getDoubleValue();
    }

    public int getInt() throws IOException {
        return this.parser.getIntValue();
    }

    public long getLong() throws IOException {
        return this.parser.getLongValue();
    }

    public String getString() throws IOException {
        return this.parser.getValueAsString();
    }

    public String getFieldName() throws IOException {
        return this.parser.currentName();
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public JsonReader bufferObject() throws IOException {
        JsonToken currentToken = this.currentToken();
        if (currentToken == JsonToken.START_OBJECT || currentToken == JsonToken.FIELD_NAME) {
            String json = this.readRemainingFieldsAsJsonObject();
            return AzureJsonUtils.createReader(json, this.jsonOptions);
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Cannot buffer a JSON object from a non-object, non-field name starting location. Starting location: " + this.currentToken()));
    }

    public boolean isResetSupported() {
        return this.resetSupported;
    }

    public JsonReader reset() throws IOException {
        if (!this.resetSupported) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("'reset' isn't supported by this JsonReader."));
        }
        return this.jsonBytes != null ? AzureJsonUtils.createReader(this.jsonBytes, this.jsonOptions) : AzureJsonUtils.createReader(this.jsonString, this.jsonOptions);
    }

    private static JsonToken mapToken(com.fasterxml.jackson.core.JsonToken nextToken, JsonToken currentToken) {
        if (nextToken == null && currentToken == null) {
            return null;
        }
        if (nextToken == null) {
            return JsonToken.END_DOCUMENT;
        }
        switch (nextToken) {
            case START_OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case START_ARRAY: {
                return JsonToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case FIELD_NAME: {
                return JsonToken.FIELD_NAME;
            }
            case VALUE_STRING: {
                return JsonToken.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return JsonToken.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return JsonToken.BOOLEAN;
            }
            case VALUE_NULL: {
                return JsonToken.NULL;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Unsupported token type: '" + nextToken + "'."));
    }
}

