/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import java.time.Instant;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtLogRecord;

class WrappedExtLogRecord
extends ExtLogRecord {
    private static final long serialVersionUID = 980830752574061944L;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    private static final MethodHandle getLongThreadID;
    private static final MethodHandle setLongThreadID;
    private final transient LogRecord orig;
    private transient boolean resolved;

    WrappedExtLogRecord(LogRecord orig) {
        super(orig.getLevel(), orig.getMessage(), LOGGER_CLASS_NAME);
        this.orig = orig;
        if (getLongThreadID == null) {
            this.setLongThreadID(this.getThreadID());
        }
    }

    @Override
    public String getLoggerName() {
        return this.orig.getLoggerName();
    }

    @Override
    public void setLoggerName(String name) {
        super.setLoggerName(name);
        this.orig.setLoggerName(name);
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.orig.getResourceBundle();
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        super.setResourceBundle(bundle);
        this.orig.setResourceBundle(bundle);
    }

    @Override
    public String getResourceBundleName() {
        return this.orig.getResourceBundleName();
    }

    @Override
    public void setResourceBundleName(String name) {
        super.setResourceBundleName(name);
        this.orig.setResourceBundleName(name);
    }

    @Override
    public Level getLevel() {
        return this.orig.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.orig.setLevel(level);
    }

    @Override
    public long getSequenceNumber() {
        return this.orig.getSequenceNumber();
    }

    @Override
    public void setSequenceNumber(long seq) {
        super.setSequenceNumber(seq);
        this.orig.setSequenceNumber(seq);
    }

    @Override
    public String getSourceClassName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.resolved = true;
        super.setSourceClassName(sourceClassName);
        this.orig.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.resolved = true;
        super.setSourceMethodName(sourceMethodName);
        this.orig.setSourceMethodName(sourceMethodName);
    }

    private void resolve() {
        StackTraceElement[] st;
        this.resolved = true;
        String sourceMethodName = this.orig.getSourceMethodName();
        String sourceClassName = this.orig.getSourceClassName();
        super.setSourceMethodName(sourceMethodName);
        super.setSourceClassName(sourceClassName);
        for (StackTraceElement element : st = new Throwable().getStackTrace()) {
            if (!element.getClassName().equals(sourceClassName) || !element.getMethodName().equals(sourceMethodName)) continue;
            super.setSourceLineNumber(element.getLineNumber());
            super.setSourceFileName(element.getFileName());
            return;
        }
    }

    @Override
    public int getSourceLineNumber() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceLineNumber();
    }

    @Override
    public void setSourceLineNumber(int sourceLineNumber) {
        this.resolved = true;
        super.setSourceLineNumber(sourceLineNumber);
    }

    @Override
    public String getSourceFileName() {
        if (!this.resolved) {
            this.resolve();
        }
        return super.getSourceFileName();
    }

    @Override
    public void setSourceFileName(String sourceFileName) {
        this.resolved = true;
        super.setSourceFileName(sourceFileName);
    }

    @Override
    public String getMessage() {
        return this.orig.getMessage();
    }

    @Override
    public void setMessage(String message) {
        super.setMessage(message);
        this.orig.setMessage(message);
    }

    @Override
    public void setMessage(String message, ExtLogRecord.FormatStyle formatStyle) {
        super.setMessage(message, formatStyle);
        this.orig.setMessage(message);
    }

    @Override
    public Object[] getParameters() {
        return this.orig.getParameters();
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.orig.setParameters(parameters);
    }

    @Override
    public int getThreadID() {
        return this.orig.getThreadID();
    }

    @Override
    public void setThreadID(int threadID) {
        super.setThreadID(threadID);
        this.orig.setThreadID(threadID);
    }

    @Override
    public long getLongThreadID() {
        try {
            return getLongThreadID == null ? super.getLongThreadID() : getLongThreadID.invokeExact(this.orig);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public ExtLogRecord setLongThreadID(long id) {
        super.setLongThreadID(id);
        if (setLongThreadID != null) {
            try {
                setLongThreadID.invokeExact(this.orig, id);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return this;
    }

    @Override
    public long getMillis() {
        return this.orig.getMillis();
    }

    @Override
    @Deprecated
    public void setMillis(long millis) {
        this.orig.setMillis(millis);
    }

    @Override
    public Instant getInstant() {
        return this.orig.getInstant();
    }

    @Override
    public void setInstant(Instant instant) {
        this.orig.setInstant(instant);
    }

    @Override
    public Throwable getThrown() {
        return this.orig.getThrown();
    }

    @Override
    public void setThrown(Throwable thrown) {
        this.orig.setThrown(thrown);
    }

    protected Object writeReplace() {
        return new ExtLogRecord(this);
    }

    static {
        MethodHandle getter = null;
        MethodHandle setter = null;
        try {
            MethodHandles.Lookup pl = MethodHandles.publicLookup();
            getter = pl.findVirtual(LogRecord.class, "getLongThreadID", MethodType.methodType(Long.TYPE));
            setter = pl.findVirtual(LogRecord.class, "setLongThreadID", MethodType.methodType(LogRecord.class, Long.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        getLongThreadID = getter;
        setLongThreadID = setter;
    }
}

