/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.NameResolverProvider;
import reactor.netty.transport.ProxyProvider;
import reactor.netty.transport.Transport;
import reactor.util.annotation.Nullable;

public abstract class ClientTransport<T extends ClientTransport<T, CONF>, CONF extends ClientTransportConfig<CONF>>
extends Transport<T, CONF> {
    protected Mono<? extends Connection> connect() {
        ClientTransportConfig config;
        ClientTransportConfig originalConfiguration = (ClientTransportConfig)this.configuration();
        if (originalConfiguration.proxyProvider() == null) {
            Supplier<ProxyProvider> proxyProviderSupplier = originalConfiguration.proxyProviderSupplier();
            if (proxyProviderSupplier != null) {
                ClientTransport dup = (ClientTransport)this.duplicate();
                config = (ClientTransportConfig)dup.configuration();
                config.proxyProvider(proxyProviderSupplier.get());
            } else {
                config = originalConfiguration;
            }
        } else {
            config = originalConfiguration;
        }
        ConnectionObserver observer = config.defaultConnectionObserver().then(config.observer);
        AddressResolverGroup<?> resolver = config.resolverInternal();
        Mono mono = config.connectionProvider().acquire(config, observer, config.remoteAddress, resolver);
        if (config.doOnConnect != null) {
            mono = mono.doOnSubscribe(s -> config.doOnConnect.accept(config));
        }
        return mono;
    }

    protected Connection connectNow() {
        return this.connectNow(Duration.ofSeconds(45L));
    }

    protected Connection connectNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull((Connection)this.connect().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public T doOnConnect(Consumer<? super CONF> doOnConnect) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        ClientTransport dup = (ClientTransport)this.duplicate();
        Consumer current = ((ClientTransportConfig)this.configuration()).doOnConnect;
        ((ClientTransportConfig)dup.configuration()).doOnConnect = current == null ? doOnConnect : current.andThen(doOnConnect);
        return (T)dup;
    }

    public T doOnConnected(Consumer<? super Connection> doOnConnected) {
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        ClientTransport dup = (ClientTransport)this.duplicate();
        Consumer<? super Connection> current = ((ClientTransportConfig)this.configuration()).doOnConnected;
        ((ClientTransportConfig)dup.configuration()).doOnConnected = current == null ? doOnConnected : current.andThen(doOnConnected);
        return (T)dup;
    }

    public T doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        ClientTransport dup = (ClientTransport)this.duplicate();
        Consumer<? super Connection> current = ((ClientTransportConfig)this.configuration()).doOnDisconnected;
        ((ClientTransportConfig)dup.configuration()).doOnDisconnected = current == null ? doOnDisconnected : current.andThen(doOnDisconnected);
        return (T)dup;
    }

    public final T doOnResolve(Consumer<? super Connection> doOnResolve) {
        Objects.requireNonNull(doOnResolve, "doOnResolve");
        ClientTransport dup = (ClientTransport)this.duplicate();
        Consumer<? super Connection> current = ((ClientTransportConfig)this.configuration()).doOnResolve;
        ((ClientTransportConfig)dup.configuration()).doOnResolve = current == null ? doOnResolve : current.andThen(doOnResolve);
        return (T)dup;
    }

    public final T doAfterResolve(BiConsumer<? super Connection, ? super SocketAddress> doAfterResolve) {
        Objects.requireNonNull(doAfterResolve, "doAfterResolve");
        ClientTransport dup = (ClientTransport)this.duplicate();
        BiConsumer<? super Connection, ? super SocketAddress> current = ((ClientTransportConfig)this.configuration()).doAfterResolve;
        ((ClientTransportConfig)dup.configuration()).doAfterResolve = current == null ? doAfterResolve : current.andThen(doAfterResolve);
        return (T)dup;
    }

    public final T doOnResolveError(BiConsumer<? super Connection, ? super Throwable> doOnResolveError) {
        Objects.requireNonNull(doOnResolveError, "doOnResolveError");
        ClientTransport dup = (ClientTransport)this.duplicate();
        BiConsumer<? super Connection, ? super Throwable> current = ((ClientTransportConfig)this.configuration()).doOnResolveError;
        ((ClientTransportConfig)dup.configuration()).doOnResolveError = current == null ? doOnResolveError : current.andThen(doOnResolveError);
        return (T)dup;
    }

    public T host(String host) {
        Objects.requireNonNull(host, "host");
        return this.remoteAddress(() -> AddressUtils.updateHost(((ClientTransportConfig)this.configuration()).remoteAddress(), host));
    }

    public T noProxy() {
        if (((ClientTransportConfig)this.configuration()).hasProxy()) {
            ClientTransport dup = (ClientTransport)this.duplicate();
            ((ClientTransportConfig)dup.configuration()).proxyProvider = null;
            ((ClientTransportConfig)dup.configuration()).proxyProviderSupplier = null;
            if (((ClientTransportConfig)dup.configuration()).resolver == NoopAddressResolverGroup.INSTANCE) {
                ((ClientTransportConfig)dup.configuration()).resolver = null;
            }
            return (T)dup;
        }
        ClientTransport dup = this;
        return (T)dup;
    }

    public T port(int port) {
        return this.remoteAddress(() -> AddressUtils.updatePort(((ClientTransportConfig)this.configuration()).remoteAddress(), port));
    }

    public T proxy(Consumer<? super ProxyProvider.TypeSpec> proxyOptions) {
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        ProxyProvider.Build builder = (ProxyProvider.Build)ProxyProvider.builder();
        proxyOptions.accept(builder);
        return this.proxyWithProxyProviderSupplier(builder::build);
    }

    final T proxyWithProxyProvider(ProxyProvider proxy) {
        ClientTransport dup = (ClientTransport)this.duplicate();
        ClientTransportConfig conf = (ClientTransportConfig)dup.configuration();
        conf.proxyProvider = proxy;
        conf.proxyProviderSupplier = null;
        if (conf.resolver == null) {
            conf.resolver = NoopAddressResolverGroup.INSTANCE;
        }
        return (T)dup;
    }

    final T proxyWithProxyProviderSupplier(Supplier<ProxyProvider> proxy) {
        ClientTransport dup = (ClientTransport)this.duplicate();
        ClientTransportConfig conf = (ClientTransportConfig)dup.configuration();
        conf.proxyProvider = null;
        conf.proxyProviderSupplier = proxy;
        if (conf.resolver == null) {
            conf.resolver = NoopAddressResolverGroup.INSTANCE;
        }
        return (T)dup;
    }

    public final T proxyWithSystemProperties() {
        return this.proxyWithSystemProperties(System.getProperties());
    }

    final T proxyWithSystemProperties(Properties properties) {
        ProxyProvider proxy = ProxyProvider.createFrom(properties);
        return proxy == null ? this.noProxy() : this.proxyWithProxyProvider(proxy);
    }

    public T remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        Objects.requireNonNull(remoteAddressSupplier, "remoteAddressSupplier");
        ClientTransport dup = (ClientTransport)this.duplicate();
        ((ClientTransportConfig)dup.configuration()).remoteAddress = remoteAddressSupplier;
        return (T)dup;
    }

    public T resolvedAddressesSelector(ResolvedAddressSelector<? super CONF> resolvedAddressesSelector) {
        Objects.requireNonNull(resolvedAddressesSelector, "resolvedAddressesSelector");
        ClientTransport dup = (ClientTransport)this.duplicate();
        ((ClientTransportConfig)dup.configuration()).resolvedAddressesSelector = resolvedAddressesSelector;
        return (T)dup;
    }

    public T resolver(AddressResolverGroup<?> resolver) {
        Objects.requireNonNull(resolver, "resolver");
        ClientTransport dup = (ClientTransport)this.duplicate();
        ((ClientTransportConfig)dup.configuration()).resolver = resolver;
        ((ClientTransportConfig)dup.configuration()).nameResolverProvider = null;
        return (T)dup;
    }

    public T resolver(Consumer<NameResolverProvider.NameResolverSpec> nameResolverSpec) {
        Objects.requireNonNull(nameResolverSpec, "nameResolverSpec");
        NameResolverProvider.Build builder = new NameResolverProvider.Build();
        nameResolverSpec.accept(builder);
        NameResolverProvider provider = builder.build();
        if (provider.equals(((ClientTransportConfig)this.configuration()).nameResolverProvider)) {
            ClientTransport dup = this;
            return (T)dup;
        }
        ClientTransport dup = (ClientTransport)this.duplicate();
        ClientTransportConfig conf = (ClientTransportConfig)dup.configuration();
        conf.nameResolverProvider = provider;
        conf.resolver = provider.newNameResolverGroup(conf.loopResources(), conf.preferNative);
        return (T)dup;
    }

    @Override
    public T runOn(LoopResources loopResources, boolean preferNative) {
        ClientTransport dup = (ClientTransport)super.runOn(loopResources, preferNative);
        ClientTransportConfig conf = (ClientTransportConfig)dup.configuration();
        if (conf.nameResolverProvider != null) {
            conf.resolver = ClientTransportConfig.getOrCreateResolver(conf.nameResolverProvider, conf.loopResources(), conf.preferNative);
        } else if (conf.resolver == null) {
            conf.nameResolverProvider = ClientTransportConfig.DEFAULT_NAME_RESOLVER_PROVIDER;
            conf.resolver = ClientTransportConfig.getOrCreateResolver(ClientTransportConfig.DEFAULT_NAME_RESOLVER_PROVIDER, conf.loopResources(), conf.preferNative);
        }
        return (T)dup;
    }

    public Mono<Void> warmup() {
        return Mono.fromRunnable(() -> {
            ((ClientTransportConfig)this.configuration()).eventLoopGroup();
            ((ClientTransportConfig)this.configuration()).resolverInternal();
        });
    }

    public static interface ResolvedAddressSelector<CONF>
    extends BiFunction<CONF, List<? extends SocketAddress>, List<? extends SocketAddress>> {
        @Override
        @Nullable
        public List<? extends SocketAddress> apply(CONF var1, List<? extends SocketAddress> var2);
    }
}

