/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Catalog;

@ApiModel(description="A list of Catalog objects")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Catalogs {
    @NotNull
    @Valid
    private final @NotNull @Valid List<@Valid Catalog> catalogs;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="catalogs", required=true)
    public List<@Valid Catalog> getCatalogs() {
        return this.catalogs;
    }

    @JsonCreator
    public Catalogs(@JsonProperty(value="catalogs", required=true) List<@Valid Catalog> catalogs) {
        this.catalogs = Objects.requireNonNullElse(catalogs, new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<@Valid Catalog> catalogs) {
        return new Builder(catalogs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Catalogs catalogs = (Catalogs)o;
        return Objects.equals(this.catalogs, catalogs.catalogs);
    }

    public int hashCode() {
        return Objects.hash(this.catalogs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Catalogs {\n");
        sb.append("    catalogs: ").append(this.toIndentedString(this.catalogs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<@Valid Catalog> catalogs;

        private Builder() {
        }

        private Builder(List<@Valid Catalog> catalogs) {
            this.catalogs = Objects.requireNonNullElse(catalogs, new ArrayList());
        }

        public Builder setCatalogs(List<@Valid Catalog> catalogs) {
            this.catalogs = catalogs;
            return this;
        }

        public Catalogs build() {
            Catalogs inst = new Catalogs(this.catalogs);
            return inst;
        }
    }
}

