/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.storage.FileStorageConfigurationInfo;
import org.apache.polaris.core.storage.LocationRestrictions;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.core.storage.gcp.GcpStorageConfigurationInfo;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwsStorageConfigurationInfo.class), @JsonSubTypes.Type(value=AzureStorageConfigurationInfo.class), @JsonSubTypes.Type(value=GcpStorageConfigurationInfo.class), @JsonSubTypes.Type(value=FileStorageConfigurationInfo.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class PolarisStorageConfigurationInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisStorageConfigurationInfo.class);
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    @Value.Check
    protected void check() {
        if (this.validatePrefix()) {
            this.getAllowedLocations().forEach(this::validatePrefixForStorageType);
        }
    }

    @JsonIgnore
    @Value.Auxiliary
    public boolean validatePrefix() {
        return true;
    }

    public abstract List<String> getAllowedLocations();

    public abstract StorageType getStorageType();

    public String serialize() {
        try {
            return DEFAULT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("serialize failed: " + e.getMessage(), e);
        }
    }

    public static PolarisStorageConfigurationInfo deserialize(@Nonnull String jsonStr) {
        try {
            return (PolarisStorageConfigurationInfo)DEFAULT_MAPPER.readValue(jsonStr, PolarisStorageConfigurationInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("deserialize failed: " + e.getMessage(), e);
        }
    }

    public static Optional<LocationRestrictions> forEntityPath(RealmConfig realmConfig, List<PolarisEntity> entityPath) {
        return PolarisStorageConfigurationInfo.findStorageInfoFromHierarchy(entityPath).map(storageInfo -> PolarisStorageConfigurationInfo.deserialize(storageInfo.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName()))).map(configInfo -> {
            ArrayList entityPathReversed = new ArrayList(entityPath);
            Collections.reverse(entityPathReversed);
            String baseLocation = entityPathReversed.stream().flatMap(e -> Optional.ofNullable(e.getPropertiesAsMap().get("location")).stream()).findFirst().orElse(null);
            CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)entityPath.get(0));
            boolean allowEscape = realmConfig.getConfig(FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION, catalog);
            if (!allowEscape && catalog.getCatalogType() != Catalog.TypeEnum.EXTERNAL && baseLocation != null) {
                LOGGER.debug("Not allowing unstructured table location for entity: {}", (Object)((PolarisEntity)entityPathReversed.get(0)).getName());
                return new LocationRestrictions((PolarisStorageConfigurationInfo)configInfo, baseLocation);
            }
            LOGGER.debug("Allowing unstructured table location for entity: {}", (Object)((PolarisEntity)entityPathReversed.get(0)).getName());
            return new LocationRestrictions((PolarisStorageConfigurationInfo)configInfo);
        });
    }

    @Nonnull
    private static Optional<PolarisEntity> findStorageInfoFromHierarchy(List<PolarisEntity> entityPath) {
        for (int i = entityPath.size() - 1; i >= 0; --i) {
            PolarisEntity e = entityPath.get(i);
            if (!e.getInternalPropertiesAsMap().containsKey(PolarisEntityConstants.getStorageConfigInfoPropertyName())) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public abstract String getFileIoImplClassName();

    protected void validatePrefixForStorageType(String loc) {
        if (this.getStorageType().prefixes.stream().noneMatch(p -> loc.toLowerCase(Locale.ROOT).startsWith((String)p))) {
            throw new IllegalArgumentException(String.format("Location prefix not allowed: '%s', expected prefixes: '%s'", loc, String.join((CharSequence)",", this.getStorageType().prefixes)));
        }
    }

    static {
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static enum StorageType {
        S3(List.of("s3://", "s3a://")),
        AZURE(List.of("abfs://", "wasb://", "abfss://", "wasbs://")),
        GCS("gs://"),
        FILE("file://");

        private final List<String> prefixes;

        private StorageType(String prefix) {
            this.prefixes = List.of(prefix);
        }

        private StorageType(List<String> prefixes) {
            this.prefixes = prefixes;
        }

        public List<String> getPrefixes() {
            return this.prefixes;
        }
    }
}

