/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.async.FutureCancellationEvent;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureExecution<V>
implements FaultToleranceStrategy<java.util.concurrent.Future<V>> {
    private final FaultToleranceStrategy<java.util.concurrent.Future<V>> delegate;
    private final Executor executor;

    public FutureExecution(FaultToleranceStrategy<java.util.concurrent.Future<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    @Override
    public Future<java.util.concurrent.Future<V>> apply(FaultToleranceContext<java.util.concurrent.Future<V>> ctx) {
        AsyncLogger.LOG.trace("FutureExecution started");
        try {
            Future<java.util.concurrent.Future<V>> future = Future.of(this.doApply(ctx));
            return future;
        }
        finally {
            AsyncLogger.LOG.trace("FutureExecution finished");
        }
    }

    private java.util.concurrent.Future<V> doApply(final FaultToleranceContext<java.util.concurrent.Future<V>> ctx) {
        final FutureTask<java.util.concurrent.Future> task = new FutureTask<java.util.concurrent.Future>(() -> {
            try {
                return this.delegate.apply(ctx).awaitBlocking();
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        });
        this.executor.execute(task);
        return new java.util.concurrent.Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ctx.fireEvent(mayInterruptIfRunning ? FutureCancellationEvent.INTERRUPTIBLE : FutureCancellationEvent.NONINTERRUPTIBLE);
                return task.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return task.isCancelled();
            }

            @Override
            public boolean isDone() {
                try {
                    return task.isDone() && (task.isCancelled() || ((java.util.concurrent.Future)task.get()).isDone());
                }
                catch (InterruptedException e) {
                    throw SneakyThrow.sneakyThrow(e);
                }
                catch (CancellationException | ExecutionException e) {
                    return true;
                }
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return ((java.util.concurrent.Future)task.get()).get();
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return ((java.util.concurrent.Future)task.get(timeout, unit)).get(timeout, unit);
            }
        };
    }
}

