/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;

public class ResultSetIterator<T>
implements Iterator<T> {
    private final ResultSet resultSet;
    private final Converter<T> converterInstance;
    private boolean hasNext;

    public ResultSetIterator(ResultSet resultSet, Converter<T> converterInstance) throws SQLException {
        this.resultSet = resultSet;
        this.converterInstance = converterInstance;
        this.advance();
    }

    private void advance() throws SQLException {
        try {
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException e) {
            this.hasNext = false;
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            T object = this.converterInstance.fromResultSet(this.resultSet);
            this.advance();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<T> toStream() {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(this, 0);
        return StreamSupport.stream(spliterator, false);
    }
}

