/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.internal.TimeoutHelper;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private static final String TIMEOUT_ERROR_MESSAGE = "Command marker exceeded the timeout limit.";
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled((String)mongoCrypt.getCryptSharedLibVersionString(), (AutoEncryptionSettings)settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder((Map)extraOptions);
                MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)((String)extraOptions.get("mongocryptdURI"))));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command, @Nullable Timeout operationTimeout) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
                catch (MongoOperationTimeoutException e) {
                    throw e;
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder);
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand, @Nullable Timeout operationTimeout) {
        Assertions.assertNotNull((Object)this.client);
        MongoDatabase mongoDatabase = this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary());
        return TimeoutHelper.databaseWithTimeout(mongoDatabase, TIMEOUT_ERROR_MESSAGE, operationTimeout).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), (Throwable)e);
    }
}

