/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.hop.core.Const;
import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiMenuWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypePluginType;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.apache.hop.ui.hopgui.perspective.TabCloseHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemReorder;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerFilePaintListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRefreshListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerRootChangedListener;
import org.apache.hop.ui.hopgui.perspective.explorer.IExplorerSelectionListener;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.apache.hop.ui.hopgui.perspective.explorer.file.ExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.FolderFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.GenericFileType;
import org.apache.hop.ui.hopgui.selection.HopGuiSelectionTracker;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;

@HopPerspectivePlugin(id="100-HopExplorerPerspective", name="i18n::ExplorerPerspective.Name", description="The Hop Explorer Perspective", image="ui/images/folder.svg", documentationUrl="/hop-gui/perspective-file-explorer.html")
@GuiPlugin(name="i18n::ExplorerPerspective.Name", description="i18n::ExplorerPerspective.GuiPlugin.Description")
public class ExplorerPerspective
implements IHopPerspective,
TabClosable {
    public static final Class<?> PKG = ExplorerPerspective.class;
    public static final String GUI_TOOLBAR_CREATED_CALLBACK_ID = "ExplorerPerspective-Toolbar-Created";
    public static final String GUI_CONTEXT_MENU_CREATED_CALLBACK_ID = "ExplorerPerspective-ContextMenu-Created";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "ExplorerPerspective-Toolbar";
    public static final String GUI_PLUGIN_CONTEXT_MENU_PARENT_ID = "ExplorerPerspective-ContextMenu";
    public static final String TOOLBAR_ITEM_OPEN = "ExplorerPerspective-Toolbar-10000-Open";
    public static final String TOOLBAR_ITEM_CREATE_FOLDER = "ExplorerPerspective-Toolbar-10050-CreateFolder";
    public static final String TOOLBAR_ITEM_EXPAND_ALL = "ExplorerPerspective-Toolbar-10060-ExpandAll";
    public static final String TOOLBAR_ITEM_COLLAPSE_ALL = "ExplorerPerspective-Toolbar-10070-CollapseAll";
    public static final String TOOLBAR_ITEM_DELETE = "ExplorerPerspective-Toolbar-10100-Delete";
    public static final String TOOLBAR_ITEM_RENAME = "ExplorerPerspective-Toolbar-10200-Rename";
    public static final String TOOLBAR_ITEM_REFRESH = "ExplorerPerspective-Toolbar-10300-Refresh";
    public static final String TOOLBAR_ITEM_SHOW_HIDDEN = "ExplorerPerspective-Toolbar-10400-Show-hidden";
    public static final String TOOLBAR_ITEM_SELECT_OPENED_FILE = "ExplorerPerspective-Toolbar-10500-Select-opened-file";
    public static final String CONTEXT_MENU_CREATE_FOLDER = "ExplorerPerspective-ContextMenu-10050-CreateFolder";
    public static final String CONTEXT_MENU_EXPAND_ALL = "ExplorerPerspective-ContextMenu-10060-ExpandAll";
    public static final String CONTEXT_MENU_COLLAPSE_ALL = "ExplorerPerspective-ContextMenu-10070-CollapseAll";
    public static final String CONTEXT_MENU_OPEN = "ExplorerPerspective-ContextMenu-10100-Open";
    public static final String CONTEXT_MENU_RENAME = "ExplorerPerspective-ContextMenu-10300-Rename";
    public static final String CONTEXT_MENU_COPY_NAME = "ExplorerPerspective-ContextMenu-10400-CopyName";
    public static final String CONTEXT_MENU_COPY_PATH = "ExplorerPerspective-ContextMenu-10401-CopyPath";
    public static final String CONTEXT_MENU_DELETE = "ExplorerPerspective-ContextMenu-90000-Delete";
    private static final String FILE_EXPLORER_TREE = "File explorer tree";
    private static ExplorerPerspective instance;
    private GuiToolbarWidgets toolBarWidgets;
    private final ExplorerFileType explorerFileType;
    private final HopPipelineFileType<PipelineMeta> pipelineFileType;
    private final HopWorkflowFileType<WorkflowMeta> workflowFileType;
    private HopGui hopGui;
    private SashForm sash;
    private Tree tree;
    private TreeEditor treeEditor;
    private CTabFolder tabFolder;
    private ToolBar toolBar;
    private GuiMenuWidgets menuWidgets;
    private final List<TabItemHandler> items;
    private boolean showingHiddenFiles;
    private boolean fileExplorerPanelVisible = true;
    private String rootFolder;
    private String rootName;
    private String dragFile;
    private int dropOperation;
    private List<IExplorerFilePaintListener> filePaintListeners;
    private List<IExplorerRootChangedListener> rootChangedListeners;
    private List<IExplorerRefreshListener> refreshListeners;
    private List<IExplorerSelectionListener> selectionListeners;
    private List<IHopFileType> fileTypes;
    private Map<String, Image> typeImageMap;
    private Text searchText;
    private String filterText = "";
    private Map<String, Boolean> treeStateBeforeFilter = null;

    public ExplorerPerspective() {
        instance = this;
        this.explorerFileType = new ExplorerFileType();
        this.pipelineFileType = new HopPipelineFileType();
        this.workflowFileType = new HopWorkflowFileType();
        this.items = new CopyOnWriteArrayList<TabItemHandler>();
        this.filePaintListeners = new ArrayList<IExplorerFilePaintListener>();
        this.rootChangedListeners = new ArrayList<IExplorerRootChangedListener>();
        this.refreshListeners = new ArrayList<IExplorerRefreshListener>();
        this.selectionListeners = new ArrayList<IExplorerSelectionListener>();
        this.typeImageMap = new HashMap<String, Image>();
        this.showingHiddenFiles = false;
    }

    public static ExplorerPerspective getInstance() {
        if (instance == null) {
            new ExplorerPerspective();
        }
        return instance;
    }

    @Override
    public String getId() {
        return "explorer-perspective";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=100)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=100)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.updateGui();
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return List.of(this.explorerFileType, this.pipelineFileType, this.workflowFileType);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.determineRootFolderName(hopGui);
        this.loadFileTypes();
        this.loadTypeImages(parent);
        this.sash = new SashForm(parent, 256);
        this.sash.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        this.createTree((Composite)this.sash);
        this.createTabFolder((Composite)this.sash);
        this.sash.setWeights(new int[]{20, 80});
        Boolean visibleByDefault = ExplorerPerspectiveConfigSingleton.getConfig().getFileExplorerVisibleByDefault();
        if (visibleByDefault != null && !visibleByDefault.booleanValue()) {
            this.fileExplorerPanelVisible = false;
            this.sash.setMaximizedControl((Control)this.tabFolder);
        } else {
            this.fileExplorerPanelVisible = true;
        }
        hopGui.getEventsHandler().addEventListener(this.getClass().getName() + "ProjectActivated", e -> this.refresh(), HopGuiEvents.ProjectActivated.name());
        hopGui.getEventsHandler().addEventListener(this.getClass().getName() + "ProjectUpdated", e -> this.refresh(), HopGuiEvents.ProjectUpdated.name());
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    private void loadFileTypes() {
        this.fileTypes = new ArrayList<IHopFileType>();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = PluginRegistry.getInstance().getPlugins(HopFileTypePluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IHopFileType fileType = (IHopFileType)registry.loadClass(plugin);
                this.fileTypes.add(fileType);
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Unable to load file type plugin: " + plugin.getIds()[0], (Throwable)e);
            }
        }
        this.fileTypes.add(new GenericFileType());
    }

    private void loadTypeImages(Composite parentComposite) {
        this.typeImageMap = new HashMap<String, Image>();
        int iconSize = (int)(PropsUi.getInstance().getZoomFactor() * 16.0);
        for (IHopFileType fileType : this.fileTypes) {
            String imageFilename = fileType.getFileTypeImage();
            if (imageFilename == null) continue;
            try {
                SvgCacheEntry svgCacheEntry = SvgCache.loadSvg((SvgFile)new SvgFile(imageFilename, fileType.getClass().getClassLoader()));
                SwtUniversalImageSvg imageSvg = new SwtUniversalImageSvg(new SvgImage((Document)svgCacheEntry.getSvgDocument()));
                Image image = imageSvg.getAsBitmapForSize((Device)this.hopGui.getDisplay(), iconSize, iconSize);
                this.typeImageMap.put(fileType.getName(), image);
            }
            catch (Exception e2) {
                this.hopGui.getLog().logError("Error loading image : '" + imageFilename + "' for type '" + fileType.getName() + "'", (Throwable)e2);
            }
        }
        parentComposite.addListener(12, e -> {
            for (Image image : this.typeImageMap.values()) {
                image.dispose();
            }
        });
    }

    public void determineRootFolderName(HopGui hopGui) {
        String oldRootFolder = this.rootFolder;
        String oldRootName = this.rootName;
        this.rootFolder = hopGui.getVariables().getVariable("user.home");
        this.rootName = "Home folder";
        DetermineRootFolderExtension ext = new DetermineRootFolderExtension(hopGui, this.rootFolder, this.rootName);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)hopGui.getVariables(), (String)HopGuiExtensionPoint.HopGuiDetermineExplorerRoot.id, (Object)ext);
            this.rootFolder = ext.rootFolder;
            this.rootName = ext.rootName;
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RootFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RootFolder.Message", (String[])new String[0]), e);
        }
        if (!StringUtils.equals((String)oldRootFolder, (String)this.rootFolder) || !StringUtils.equals((String)oldRootName, (String)this.rootName)) {
            for (IExplorerRootChangedListener listener : this.rootChangedListeners) {
                listener.rootChanged(this.rootFolder, this.rootName);
            }
        }
    }

    protected void createTree(Composite parent) {
        Composite treeComposite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        treeComposite.setLayout((Layout)layout);
        this.searchText = new Text(treeComposite, 896);
        this.searchText.setMessage(BaseMessages.getString(PKG, (String)"ExplorerPerspective.Search.Placeholder", (String[])new String[0]));
        PropsUi.setLook((Widget)this.searchText);
        FormData searchFormData = new FormData();
        searchFormData.left = new FormAttachment(0, 0);
        searchFormData.top = new FormAttachment(0, 0);
        searchFormData.right = new FormAttachment(100, 0);
        this.searchText.setLayoutData((Object)searchFormData);
        this.searchText.addListener(24, event -> {
            boolean willFilter;
            String text = this.searchText.getText();
            boolean wasFiltering = !Utils.isEmpty((CharSequence)this.filterText);
            boolean bl = willFilter = text != null && text.length() > 2;
            if (!wasFiltering && willFilter) {
                this.saveTreeState();
            }
            this.filterText = willFilter ? text.toLowerCase() : "";
            this.refresh();
            if (wasFiltering && !willFilter) {
                this.restoreTreeState();
            }
        });
        Composite composite = new Composite(treeComposite, 2048);
        composite.setLayout((Layout)new FormLayout());
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment((Control)this.searchText, PropsUi.getMargin());
        layoutData.right = new FormAttachment(100, 0);
        layoutData.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)layoutData);
        this.toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData toolBarFormData = new FormData();
        toolBarFormData.left = new FormAttachment(0, 0);
        toolBarFormData.top = new FormAttachment(0, 0);
        toolBarFormData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)toolBarFormData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.tree = new Tree(composite, 772);
        this.tree.setHeaderVisible(false);
        this.tree.addListener(13, event -> this.updateSelection());
        this.tree.addListener(14, this::openFile);
        PropsUi.setLook((Widget)this.tree);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)this.toolBar, PropsUi.getMargin());
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)treeFormData);
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.tree.addListener(17, this::lazyLoadFolderOnExpand);
        Menu menu = new Menu((Control)this.tree);
        this.menuWidgets = new GuiMenuWidgets();
        this.menuWidgets.registerGuiPluginObject(this);
        this.menuWidgets.createMenuWidgets(GUI_PLUGIN_CONTEXT_MENU_PARENT_ID, this.getShell(), menu);
        this.tree.setMenu(menu);
        this.tree.addListener(35, event -> {
            if (this.tree.getSelectionCount() < 1) {
                return;
            }
            TreeItem[] selection = this.tree.getSelection();
            this.menuWidgets.findMenuItem(CONTEXT_MENU_OPEN).setEnabled(selection.length == 1);
            this.menuWidgets.findMenuItem(CONTEXT_MENU_RENAME).setEnabled(selection.length == 1);
            menu.setVisible(true);
        });
        this.createTreeDragSource(this.tree);
        this.createTreeDropTarget(this.tree);
        TreeMemory.addTreeListener(this.tree, FILE_EXPLORER_TREE);
        GuiRegistry.getInstance().executeCallbackMethods(GUI_TOOLBAR_CREATED_CALLBACK_ID);
        GuiRegistry.getInstance().executeCallbackMethods(GUI_CONTEXT_MENU_CREATED_CALLBACK_ID);
    }

    private DragSource createTreeDragSource(Tree tree) {
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        DragSource dragSource = new DragSource((Control)tree, 3);
        dragSource.setTransfer(new Transfer[]{fileTransfer});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                ExplorerFile file = ExplorerPerspective.this.getSelectedFile();
                String metadataFolder = ExplorerPerspective.this.hopGui.getVariables().getVariable("HOP_METADATA_FOLDER");
                if (file == null || file.getFilename().equals(ExplorerPerspective.this.rootFolder) || file.getFilename().contains(metadataFolder) || file.getName().startsWith(".")) {
                    event.doit = false;
                    return;
                }
                ExplorerPerspective.this.dragFile = file.getFilename();
            }

            public void dragSetData(DragSourceEvent event) {
                if (fileTransfer.isSupportedType(event.dataType)) {
                    event.doit = true;
                    event.data = new String[]{ExplorerPerspective.this.getSelectedFile().getFilename()};
                }
            }

            public void dragFinished(DragSourceEvent event) {
                ExplorerPerspective.this.dragFile = null;
            }
        });
        return dragSource;
    }

    private DropTarget createTreeDropTarget(Tree tree) {
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        DropTarget target = new DropTarget((Control)tree, 3);
        target.setTransfer(new Transfer[]{fileTransfer});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) == 0 ? 1 : 2;
                }
                ExplorerPerspective.this.dropOperation = event.detail;
                for (int i = 0; i < event.dataTypes.length; ++i) {
                    if (!fileTransfer.isSupportedType(event.dataTypes[i])) continue;
                    event.currentDataType = event.dataTypes[i];
                    break;
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 2) == 0 ? 1 : 2;
                }
                ExplorerPerspective.this.dropOperation = event.detail;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
                if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                if (event.item == null) {
                    return;
                }
                Object data = event.item.getData();
                if (data instanceof TreeItemFolder) {
                    TreeItemFolder targetItem = (TreeItemFolder)data;
                    if (targetItem.folder) {
                        event.detail = ExplorerPerspective.this.dropOperation;
                        event.feedback = 25;
                        try {
                            FileObject sourceFile;
                            FileObject targetFile = HopVfs.getFileObject((String)targetItem.path);
                            if (ExplorerPerspective.this.dragFile != null && ((sourceFile = HopVfs.getFileObject((String)ExplorerPerspective.this.dragFile)).equals(targetFile) || sourceFile.getParent().equals(targetFile) || sourceFile.getName().isDescendent(targetFile.getName()))) {
                                event.detail = 0;
                            }
                        }
                        catch (FileSystemException | HopFileException throwable) {}
                    } else {
                        event.detail = 0;
                        event.feedback = 0;
                    }
                }
            }

            public void drop(DropTargetEvent event) {
                Widget item;
                Object object;
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && (object = (item = event.item).getData()) instanceof TreeItemFolder) {
                    TreeItemFolder targetItem = (TreeItemFolder)object;
                    ArrayList<String> errors = new ArrayList<String>();
                    for (String path : (String[])event.data) {
                        try {
                            FileObject sourceFile = HopVfs.getFileObject((String)path);
                            FileObject targetFile = HopVfs.getFileObject((String)(targetItem.path + Const.FILE_SEPARATOR + sourceFile.getName().getBaseName()));
                            if (event.detail == 1) {
                                targetFile.copyFrom(sourceFile, Selectors.SELECT_ALL);
                                continue;
                            }
                            if (event.detail != 2) continue;
                            ExplorerPerspective.this.moveFile(sourceFile, targetFile);
                        }
                        catch (Exception e) {
                            errors.add(path);
                        }
                    }
                    if (!errors.isEmpty()) {
                        String paths = String.join((CharSequence)"\n", errors);
                        MessageBox messageBox = new MessageBox(HopGui.getInstance().getShell(), 33);
                        messageBox.setText("Drag and drop");
                        messageBox.setMessage("Unable to copy/move file(s):\n\n" + paths);
                        messageBox.open();
                    }
                    ExplorerPerspective.this.refresh();
                }
            }
        });
        return target;
    }

    private void lazyLoadFolderOnExpand(Event event) {
        TreeItem item = (TreeItem)event.item;
        TreeItemFolder treeItemFolder = (TreeItemFolder)item.getData();
        if (treeItemFolder != null && !treeItemFolder.loaded) {
            BusyIndicator.showWhile((Display)this.hopGui.getDisplay(), () -> {
                this.refreshFolder(item, treeItemFolder.path, treeItemFolder.depth + 1);
                treeItemFolder.loaded = true;
            });
        }
    }

    private void openFile(Event event) {
        Widget widget = event.item;
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            TreeItemFolder tif = (TreeItemFolder)item.getData();
            if (tif.folder) {
                if (!item.getExpanded()) {
                    this.lazyLoadFolderOnExpand(event);
                    item.setExpanded(true);
                } else {
                    item.setExpanded(false);
                }
                TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, item.getExpanded());
            } else {
                this.openFile(item);
            }
        }
    }

    private void openFile(TreeItem item) {
        try {
            TreeItemFolder tif = (TreeItemFolder)item.getData();
            if (tif != null && tif.fileType != null) {
                if (tif.fileType instanceof FolderFileType) {
                    boolean expanded = !item.getExpanded();
                    item.setExpanded(expanded);
                    TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, expanded);
                } else {
                    IHopFileTypeHandler handler = tif.fileType.openFile(this.hopGui, tif.path, this.hopGui.getVariables());
                    if (handler != null) {
                        handler.updateGui();
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.OpenFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.OpenFile.Message", (String[])new String[0]), e);
        }
    }

    private void deleteFile(TreeItem treeItem) {
        try {
            TreeItemFolder tif = (TreeItemFolder)treeItem.getData();
            if (tif != null && tif.fileType != null) {
                FileObject fileObject = HopVfs.getFileObject((String)tif.path);
                String header = BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFile.Confirmation.Header", (String[])new String[0]);
                String message = BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFile.Confirmation.Message", (String[])new String[0]);
                if (fileObject.isFolder()) {
                    header = BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFolder.Confirmation.Header", (String[])new String[0]);
                    message = BaseMessages.getString(PKG, (String)"ExplorerPerspective.DeleteFolder.Confirmation.Message", (String[])new String[0]);
                }
                MessageBox box = new MessageBox(this.hopGui.getShell(), 196);
                box.setText(header);
                box.setMessage(message + Const.CR + Const.CR + HopVfs.getFilename((FileObject)fileObject));
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    List<String> filenames = this.getRecursiveFilenames(fileObject, new ArrayList<String>());
                    int deleted = fileObject.deleteAll();
                    if (deleted > 0) {
                        treeItem.dispose();
                        for (String filename : filenames) {
                            TabItemHandler handler = this.findTabItemHandler(filename);
                            if (handler == null) continue;
                            this.removeTabItem(handler);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.DeleteFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.DeleteFile.Message", (String[])new String[0]), e);
        }
    }

    private List<String> getRecursiveFilenames(FileObject parentFile, List<String> list) throws FileSystemException {
        if (parentFile.isFile()) {
            list.add(HopVfs.getFilename((FileObject)parentFile));
        } else {
            for (FileObject file : parentFile.getChildren()) {
                this.getRecursiveFilenames(file, list);
            }
        }
        return list;
    }

    private void renameFile(TreeItem item) {
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.fileType != null) {
            Text text = new Text((Composite)this.tree, 2048);
            text.setText(item.getText());
            text.addListener(16, event -> text.dispose());
            text.addListener(2, event -> {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if (item.getText().equals(text.getText())) break;
                        try {
                            FileObject file = HopVfs.getFileObject((String)tif.path);
                            FileObject newFile = HopVfs.getFileObject((String)(file.getParent().getName().toString() + File.separator + text.getText()));
                            this.renameFile(file, newFile);
                            item.setText(text.getText());
                            break;
                        }
                        catch (Exception e) {
                            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RenameFile.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.RenameFile.Message", (String[])new String[0]), e);
                            break;
                        }
                        finally {
                            text.dispose();
                            this.refresh();
                        }
                    }
                    case 27: {
                        text.dispose();
                        break;
                    }
                }
            });
            text.selectAll();
            text.setFocus();
            PropsUi.setLook((Widget)text);
            this.treeEditor.setEditor((Control)text, item);
        }
    }

    private void renameFile(FileObject sourceFile, FileObject targetFile) throws FileSystemException {
        if (sourceFile.isFolder()) {
            List<String> filenames = this.getRecursiveFilenames(sourceFile, new ArrayList<String>());
            sourceFile.moveTo(targetFile);
            for (String filename : filenames) {
                TabItemHandler handler = this.findTabItemHandler(filename);
                if (handler == null) continue;
                Path oldPath = Paths.get(filename, new String[0]);
                Path targetPath = targetFile.getPath();
                Path relativePath = oldPath.subpath(targetPath.getNameCount(), oldPath.getNameCount());
                Path path = Paths.get(targetPath.toString(), relativePath.toString());
                this.changeFilename(handler.getTypeHandler(), path.toString());
                this.updateTabItem(handler.getTypeHandler());
                this.saveFileIfNameSynchronized(handler.getTypeHandler());
            }
        } else {
            sourceFile.moveTo(targetFile);
            TabItemHandler handler = this.findTabItemHandler(HopVfs.getFilename((FileObject)sourceFile));
            if (handler != null) {
                this.changeFilename(handler.getTypeHandler(), HopVfs.getFilename((FileObject)targetFile));
                this.updateTabItem(handler.getTypeHandler());
                this.saveFileIfNameSynchronized(handler.getTypeHandler());
            } else {
                this.updateClosedFileIfNameSynchronized(targetFile);
            }
        }
    }

    private void moveFile(FileObject sourceFile, FileObject targetFile) throws FileSystemException {
        if (sourceFile.isFolder()) {
            List<String> filenames = this.getRecursiveFilenames(sourceFile, new ArrayList<String>());
            sourceFile.moveTo(targetFile);
            Path sourcePath = sourceFile.getPath();
            Path targetPath = targetFile.getPath();
            for (String filename : filenames) {
                TabItemHandler handler = this.findTabItemHandler(filename);
                if (handler == null) continue;
                Path originalPath = Paths.get(filename, new String[0]);
                Path relativePath = originalPath.subpath(sourcePath.getNameCount(), originalPath.getNameCount());
                Path path = Paths.get(targetPath.toString(), relativePath.toString());
                this.changeFilename(handler.getTypeHandler(), path.toString());
                this.updateTabItem(handler.getTypeHandler());
            }
        } else {
            sourceFile.moveTo(targetFile);
            TabItemHandler handler = this.findTabItemHandler(HopVfs.getFilename((FileObject)sourceFile));
            if (handler != null) {
                handler.getTypeHandler().setFilename(HopVfs.getFilename((FileObject)targetFile));
                this.updateTabItem(handler.getTypeHandler());
            }
        }
    }

    protected void changeFilename(IHopFileTypeHandler fileTypeHandler, String newFilename) {
        String oldFilename = fileTypeHandler.getFilename();
        this.hopGui.fileRefreshDelegate.remove(oldFilename);
        fileTypeHandler.setFilename(newFilename);
        this.hopGui.fileRefreshDelegate.register(newFilename, fileTypeHandler);
    }

    private void saveFileIfNameSynchronized(IHopFileTypeHandler fileTypeHandler) {
        try {
            WorkflowMeta workflowMeta;
            PipelineMeta pipelineMeta;
            Object subject = fileTypeHandler.getSubject();
            if (subject instanceof PipelineMeta && (pipelineMeta = (PipelineMeta)subject).isNameSynchronizedWithFilename()) {
                fileTypeHandler.save();
            } else if (subject instanceof WorkflowMeta && (workflowMeta = (WorkflowMeta)subject).isNameSynchronizedWithFilename()) {
                fileTypeHandler.save();
            }
        }
        catch (Exception e) {
            this.hopGui.getLog().logError("Error saving file after rename", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClosedFileIfNameSynchronized(FileObject targetFile) {
        block9: {
            try {
                IVariables variables;
                WorkflowMeta workflowMeta;
                String filename = HopVfs.getFilename((FileObject)targetFile);
                String extension = filename.substring(filename.lastIndexOf(46));
                if (".hpl".equalsIgnoreCase(extension)) {
                    IVariables variables2 = Variables.getADefaultVariableSpace();
                    PipelineMeta pipelineMeta = new PipelineMeta(filename, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), variables2);
                    if (!pipelineMeta.isNameSynchronizedWithFilename()) break block9;
                    String xml = pipelineMeta.getXml(variables2);
                    OutputStream out = HopVfs.getOutputStream((String)filename, (boolean)false);
                    try {
                        out.write(XmlHandler.getXmlHeader((String)"UTF-8").getBytes(StandardCharsets.UTF_8));
                        out.write(xml.getBytes(StandardCharsets.UTF_8));
                        break block9;
                    }
                    finally {
                        out.flush();
                        out.close();
                    }
                }
                if (!".hwf".equalsIgnoreCase(extension) || !(workflowMeta = new WorkflowMeta(variables = Variables.getADefaultVariableSpace(), filename, (IHopMetadataProvider)this.hopGui.getMetadataProvider())).isNameSynchronizedWithFilename()) break block9;
                String xml = workflowMeta.getXml(variables);
                OutputStream out = HopVfs.getOutputStream((String)filename, (boolean)false);
                try {
                    out.write(XmlHandler.getXmlHeader((String)"UTF-8").getBytes(StandardCharsets.UTF_8));
                    out.write(xml.getBytes(StandardCharsets.UTF_8));
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Error updating closed file after rename", (Throwable)e);
            }
        }
    }

    protected void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2050);
        this.tabFolder.addListener(13, e -> this.updateGui());
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem tabItem = (CTabItem)event.item;
                ExplorerPerspective.this.closeTab(event, tabItem);
            }
        });
        PropsUi.setLook((Widget)this.tabFolder, 4);
        ToolBar tabToolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        this.tabFolder.setTopRight((Control)tabToolBar, 131072);
        PropsUi.setLook((Widget)tabToolBar);
        ToolItem item = new ToolItem(tabToolBar, 8);
        item.setImage(GuiResource.getInstance().getImageMaximizePanel());
        item.addListener(13, e -> {
            if (this.sash.getMaximizedControl() == null) {
                this.sash.setMaximizedControl((Control)this.tabFolder);
                item.setImage(GuiResource.getInstance().getImageMinimizePanel());
            } else {
                this.sash.setMaximizedControl(null);
                item.setImage(GuiResource.getInstance().getImageMaximizePanel());
            }
        });
        int height = tabToolBar.computeSize((int)-1, (int)-1).y;
        this.tabFolder.setTabHeight(Math.max(height, this.tabFolder.getTabHeight()));
        new TabCloseHandler(this);
        new TabItemReorder(this, this.tabFolder);
    }

    protected TabItemHandler findTabItemHandler(String filename) {
        if (filename != null) {
            for (TabItemHandler item : this.items) {
                if (!filename.equals(item.getTypeHandler().getFilename())) continue;
                return item;
            }
        }
        return null;
    }

    protected TabItemHandler getTabItemHandler(IHopFileTypeHandler fileTypeHandler) {
        if (fileTypeHandler != null) {
            for (TabItemHandler item : this.items) {
                if (!fileTypeHandler.equals(item.getTypeHandler())) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public void closeTab(CTabFolderEvent event, CTabItem tabItem) {
        IHopFileTypeHandler fileTypeHandler = (IHopFileTypeHandler)tabItem.getData();
        boolean isRemoved = this.remove(fileTypeHandler);
        if (!isRemoved && event != null) {
            event.doit = false;
        }
    }

    private void removeTabItem(TabItemHandler item) {
        this.items.remove(item);
        item.getTabItem().dispose();
        IHopFileTypeHandler fileTypeHandler = item.getTypeHandler();
        if (fileTypeHandler.getFilename() != null) {
            this.hopGui.fileRefreshDelegate.remove(fileTypeHandler.getFilename());
        }
        if (!this.hopGui.fileDelegate.isClosing()) {
            if (this.tabFolder.getItemCount() == 0) {
                HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
            }
            this.updateGui();
        }
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void addFile(IExplorerFileTypeHandler fileTypeHandler) {
        TabItemHandler handler = this.findTabItemHandler(fileTypeHandler.getFilename());
        if (handler != null) {
            this.tabFolder.setSelection(handler.getTabItem());
            this.tabFolder.showItem(handler.getTabItem());
            this.tabFolder.setFocus();
            return;
        }
        final CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        String displayName = this.getTabDisplayName(fileTypeHandler);
        tabItem.setText(Const.NVL((String)displayName, (String)""));
        tabItem.setToolTipText(Const.NVL((String)fileTypeHandler.getFilename(), (String)""));
        tabItem.setImage(this.getFileTypeImage(fileTypeHandler.getFileType()));
        tabItem.setData((Object)fileTypeHandler);
        fileTypeHandler.addContentChangedListener(new IContentChangedListener(){

            public void contentChanged(Object parentObject) {
                tabItem.setFont(GuiResource.getInstance().getFontBold());
            }

            public void contentSafe(Object parentObject) {
                tabItem.setFont(ExplorerPerspective.this.tabFolder.getFont());
            }
        });
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        FormLayout layoutComposite = new FormLayout();
        layoutComposite.marginWidth = PropsUi.getFormMargin();
        layoutComposite.marginHeight = PropsUi.getFormMargin();
        composite.setLayout((Layout)layoutComposite);
        composite.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        PropsUi.setLook((Widget)composite);
        fileTypeHandler.renderFile(composite);
        tabItem.setControl((Control)composite);
        this.items.add(new TabItemHandler(tabItem, fileTypeHandler));
        this.hopGui.fileRefreshDelegate.register(fileTypeHandler.getFilename(), fileTypeHandler);
        this.tabFolder.setSelection(tabItem);
        HopGuiKeyHandler keyHandler = HopGuiKeyHandler.getInstance();
        keyHandler.addParentObjectToHandle(this);
        HopGui.getInstance().replaceKeyboardShortcutListeners((Control)this.getShell(), keyHandler);
        this.updateGui();
    }

    public IHopFileTypeHandler addPipeline(PipelineMeta pipelineMeta) throws HopException {
        TabItemHandler handler = this.findTabItemHandler(pipelineMeta.getFilename());
        if (handler != null) {
            this.tabFolder.setSelection(handler.getTabItem());
            this.tabFolder.showItem(handler.getTabItem());
            this.tabFolder.setFocus();
            return handler.getTypeHandler();
        }
        HopGuiPipelineGraph pipelineGraph = new HopGuiPipelineGraph((Composite)this.tabFolder, this.hopGui, this, pipelineMeta, this.pipelineFileType);
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        tabItem.setImage(GuiResource.getInstance().getImagePipeline());
        tabItem.setText(Const.NVL((String)pipelineGraph.getName(), (String)"<>"));
        tabItem.setToolTipText(pipelineGraph.getFilename());
        tabItem.setControl((Control)pipelineGraph);
        tabItem.setData((Object)pipelineGraph);
        this.items.add(new TabItemHandler(tabItem, pipelineGraph));
        if (pipelineMeta.getFilename() != null) {
            this.hopGui.fileRefreshDelegate.register(pipelineMeta.getFilename(), pipelineGraph);
        }
        pipelineMeta.setInternalHopVariables(pipelineGraph.getVariables());
        this.hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)pipelineMeta, pipelineGraph.getVariables());
        this.tabFolder.setSelection(tabItem);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)pipelineGraph.getVariables(), (String)HopExtensionPoint.HopGuiNewPipelineTab.id, (Object)pipelineGraph);
        }
        catch (Exception e) {
            throw new HopException("Error calling extension point plugin for plugin id " + HopExtensionPoint.HopGuiNewPipelineTab.id + " trying to handle a new pipeline tab", (Throwable)e);
        }
        HopGuiKeyHandler keyHandler = HopGuiKeyHandler.getInstance();
        keyHandler.addParentObjectToHandle(this);
        HopGui.getInstance().replaceKeyboardShortcutListeners((Control)this.getShell(), keyHandler);
        pipelineGraph.setFocus();
        return pipelineGraph;
    }

    public IHopFileTypeHandler addWorkflow(WorkflowMeta workflowMeta) throws HopException {
        TabItemHandler handler = this.findTabItemHandler(workflowMeta.getFilename());
        if (handler != null) {
            this.tabFolder.setSelection(handler.getTabItem());
            this.tabFolder.showItem(handler.getTabItem());
            this.tabFolder.setFocus();
            return handler.getTypeHandler();
        }
        HopGuiWorkflowGraph workflowGraph = new HopGuiWorkflowGraph((Composite)this.tabFolder, this.hopGui, this, workflowMeta, this.workflowFileType);
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        tabItem.setImage(GuiResource.getInstance().getImageWorkflow());
        tabItem.setText(Const.NVL((String)workflowGraph.getName(), (String)"<>"));
        tabItem.setToolTipText(workflowGraph.getFilename());
        tabItem.setControl((Control)workflowGraph);
        tabItem.setData((Object)workflowGraph);
        this.items.add(new TabItemHandler(tabItem, workflowGraph));
        if (workflowMeta.getFilename() != null) {
            this.hopGui.fileRefreshDelegate.register(workflowMeta.getFilename(), workflowGraph);
        }
        workflowMeta.setInternalHopVariables(workflowGraph.getVariables());
        this.hopGui.setParametersAsVariablesInUI((INamedParameterDefinitions)workflowMeta, workflowGraph.getVariables());
        this.tabFolder.setSelection(tabItem);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.hopGui.getLog(), (IVariables)workflowGraph.getVariables(), (String)HopExtensionPoint.HopGuiNewWorkflowTab.id, (Object)workflowGraph);
        }
        catch (Exception e) {
            throw new HopException("Error calling extension point plugin for plugin id " + HopExtensionPoint.HopGuiNewWorkflowTab.id + " trying to handle a new workflow tab", (Throwable)e);
        }
        HopGuiKeyHandler keyHandler = HopGuiKeyHandler.getInstance();
        keyHandler.addParentObjectToHandle(this);
        HopGui.getInstance().replaceKeyboardShortcutListeners((Control)this.getShell(), keyHandler);
        workflowGraph.setFocus();
        return workflowGraph;
    }

    private void selectInTree(String filename) {
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        for (TreeItem item : this.tree.getItems()) {
            if (this.selectInTree(item, filename)) break;
        }
    }

    private boolean selectInTree(TreeItem item, String filename) {
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.path.equals(filename)) {
            this.tree.setSelection(tif.treeItem);
            return true;
        }
        for (TreeItem child : item.getItems()) {
            if (!this.selectInTree(child, filename)) continue;
            return true;
        }
        return false;
    }

    public ExplorerFile getSelectedFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return null;
        }
        TreeItem item = selection[0];
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null) {
            return new ExplorerFile(tif.name, tif.path, tif.fileType);
        }
        return null;
    }

    public IHopFileTypeHandler findFileTypeHandlerByFilename(String filename) {
        if (filename != null) {
            for (TabItemHandler item : this.items) {
                if (!filename.equals(item.getTypeHandler().getFilename())) continue;
                return item.getTypeHandler();
            }
        }
        return null;
    }

    public HopGuiPipelineGraph findPipeline(String logChannelId) {
        for (TabItemHandler item : this.items) {
            HopGuiPipelineGraph pipelineGraph;
            IPipelineEngine<PipelineMeta> pipeline;
            IHopFileTypeHandler iHopFileTypeHandler = item.getTypeHandler();
            if (!(iHopFileTypeHandler instanceof HopGuiPipelineGraph) || (pipeline = (pipelineGraph = (HopGuiPipelineGraph)iHopFileTypeHandler).getPipeline()) == null || !logChannelId.equals(pipeline.getLogChannelId())) continue;
            return pipelineGraph;
        }
        return null;
    }

    public HopGuiWorkflowGraph findWorkflow(String logChannelId) {
        for (TabItemHandler item : this.items) {
            HopGuiWorkflowGraph workflowGraph;
            IWorkflowEngine<WorkflowMeta> workflow;
            IHopFileTypeHandler iHopFileTypeHandler = item.getTypeHandler();
            if (!(iHopFileTypeHandler instanceof HopGuiWorkflowGraph) || (workflow = (workflowGraph = (HopGuiWorkflowGraph)iHopFileTypeHandler).getWorkflow()) == null || !logChannelId.equals(workflow.getLogChannelId())) continue;
            return workflowGraph;
        }
        return null;
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        if (this.tabFolder.getSelectionIndex() < 0) {
            return new EmptyHopFileTypeHandler();
        }
        return (IHopFileTypeHandler)this.tabFolder.getSelection().getData();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler fileTypeHandler) {
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!item.getData().equals(fileTypeHandler)) continue;
            this.tabFolder.setSelection(item);
            this.tabFolder.showItem(item);
            HopGui.getInstance().handleFileCapabilities(fileTypeHandler.getFileType(), fileTypeHandler.hasChanged(), false, false);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10100-Open", label="i18n::ExplorerPerspective.Menu.Open", image="ui/images/open.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10000-Open", toolTip="i18n::ExplorerPerspective.ToolbarElement.Open.Tooltip", image="ui/images/arrow-right.svg")
    @GuiKeyboardShortcut(key=0x100000C)
    @GuiOsxKeyboardShortcut(key=0x100000C)
    public void openFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.openFile(selection[0]);
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10050-CreateFolder", label="i18n::ExplorerPerspective.Menu.CreateFolder", image="ui/images/folder-add.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10050-CreateFolder", toolTip="i18n::ExplorerPerspective.ToolbarElement.CreateFolder.Tooltip", image="ui/images/folder-add.svg")
    public void createFolder() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TreeItem item = selection[0];
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif == null) {
            return;
        }
        EnterStringDialog dialog = new EnterStringDialog(this.getShell(), "", BaseMessages.getString(PKG, (String)"ExplorerPerspective.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.CreateFolder.Message", (String[])new String[]{tif.path}));
        String folder = dialog.open();
        if (!Utils.isEmpty((CharSequence)folder)) {
            Object newPath = tif.path;
            if (!((String)newPath).endsWith("/") && !((String)newPath).endsWith("\\")) {
                newPath = (String)newPath + "/";
            }
            newPath = (String)newPath + folder;
            try {
                FileObject newFolder = HopVfs.getFileObject((String)newPath);
                newFolder.createFolder();
                this.refresh();
            }
            catch (Throwable e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.CreateFolder.Message", (String[])new String[]{newPath}), e);
            }
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10500-Select-opened-file", toolTip="i18n::ExplorerPerspective.ToolbarElement.SelectOpenedFile.Tooltip", image="ui/images/select-target.svg")
    @GuiKeyboardShortcut(alt=true, key=0x100000A)
    @GuiOsxKeyboardShortcut(alt=true, key=0x100000A)
    public void selectInTree() {
        if (this.tabFolder.getSelectionIndex() >= 0) {
            this.selectInTree(this.getActiveFileTypeHandler().getFilename());
        }
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10060-ExpandAll", toolTip="i18n::ExplorerPerspective.ToolbarElement.ExpandAll.Tooltip", image="ui/images/expand-all.svg")
    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10060-ExpandAll", label="i18n::ExplorerPerspective.Menu.ExpandAll", image="ui/images/expand-all.svg")
    public void expandAll() {
        this.tree.setRedraw(false);
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            this.expandCollapse(this.tree.getTopItem(), true);
        } else {
            TreeItemFolder treeItemFolder = (TreeItemFolder)selection[0].getData();
            if (treeItemFolder != null && !treeItemFolder.loaded) {
                BusyIndicator.showWhile((Display)this.hopGui.getDisplay(), () -> {
                    this.refreshFolder(selection[0], treeItemFolder.path, treeItemFolder.depth + 1);
                    treeItemFolder.loaded = true;
                });
            }
            this.expandCollapse(selection[0], true);
        }
        this.tree.setRedraw(true);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10070-CollapseAll", toolTip="i18n::ExplorerPerspective.ToolbarElement.CollapseAll.Tooltip", image="ui/images/collapse-all.svg")
    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10070-CollapseAll", label="i18n::ExplorerPerspective.Menu.CollapseAll", image="ui/images/collapse-all.svg")
    public void collapsedAll() {
        this.tree.setRedraw(false);
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            this.expandCollapse(this.tree.getTopItem(), false);
        } else {
            this.expandCollapse(selection[0], false);
        }
        this.tree.setRedraw(true);
    }

    public void expandCollapse(TreeItem item, boolean expand) {
        TreeItem[] items = item.getItems();
        item.setExpanded(expand);
        TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, expand);
        for (TreeItem childItem : items) {
            if (childItem.getItemCount() < 1) continue;
            this.expandCollapse(childItem, expand);
        }
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-90000-Delete", label="i18n::ExplorerPerspective.Menu.Delete", image="ui/images/delete.svg", separator=true)
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10100-Delete", toolTip="i18n::ExplorerPerspective.ToolbarElement.Delete.Tooltip", image="ui/images/delete.svg", separator=true)
    @GuiKeyboardShortcut(key=127)
    @GuiOsxKeyboardShortcut(key=127)
    public void deleteFile() {
        HopGuiSelectionTracker selectionTracker = HopGuiSelectionTracker.getInstance();
        if (!selectionTracker.isLastSelection(HopGuiSelectionTracker.SelectionType.FILE_EXPLORER)) {
            return;
        }
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.deleteFile(selection[0]);
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10300-Rename", label="i18n::ExplorerPerspective.Menu.Rename", image="ui/images/rename.svg")
    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10200-Rename", toolTip="i18n::ExplorerPerspective.ToolbarElement.Rename.Tooltip", image="ui/images/rename.svg", separator=false)
    @GuiKeyboardShortcut(key=0x100000B)
    @GuiOsxKeyboardShortcut(key=0x100000B)
    public void renameFile() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        this.renameFile(selection[0]);
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10400-CopyName", label="i18n::ExplorerPerspective.Menu.CopyName", separator=true)
    public void copyFileName() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TreeItemFolder folder = (TreeItemFolder)selection[0].getData();
        GuiResource.getInstance().toClipboard(folder.name);
    }

    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", parentId="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-ContextMenu-10401-CopyPath", label="i18n::ExplorerPerspective.Menu.CopyPath")
    public void copyFilePath() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TreeItemFolder folder = (TreeItemFolder)selection[0].getData();
        GuiResource.getInstance().toClipboard(folder.path);
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10300-Refresh", toolTip="i18n::ExplorerPerspective.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        try {
            this.determineRootFolderName(this.hopGui);
            for (IExplorerRefreshListener listener : this.refreshListeners) {
                listener.beforeRefresh();
            }
            this.tree.setRedraw(false);
            this.tree.removeAll();
            TreeItem rootItem = new TreeItem(this.tree, 0);
            rootItem.setText(Const.NVL((String)this.rootName, (String)""));
            IHopFileType fileType = this.getFileType(this.rootFolder);
            this.setItemImage(rootItem, fileType);
            this.callPaintListeners(this.tree, rootItem, this.rootFolder, this.rootName);
            this.setTreeItemData(rootItem, this.rootFolder, this.rootName, fileType, 0, true, true);
            this.refreshFolder(rootItem, this.rootFolder, 0);
            if (!Utils.isEmpty((CharSequence)this.filterText)) {
                rootItem.setExpanded(true);
                TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, rootItem, true);
            } else {
                TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, rootItem, true);
                if (this.treeStateBeforeFilter == null) {
                    TreeMemory.setExpandedFromMemory(this.tree, FILE_EXPLORER_TREE);
                }
            }
            this.tree.setRedraw(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.TreeRefresh.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExplorerPerspective.Error.TreeRefresh.Message", (String[])new String[0]), e);
        }
        this.updateSelection();
    }

    @GuiToolbarElement(root="ExplorerPerspective-Toolbar", id="ExplorerPerspective-Toolbar-10400-Show-hidden", toolTip="i18n:org.apache.hop.ui.core.vfs:HopVfsFileDialog.ShowHiddenFiles.Tooltip.Message", image="ui/images/hide.svg")
    public void showHideHidden() {
        this.showingHiddenFiles = !this.showingHiddenFiles;
        ToolItem toolItem = this.toolBarWidgets.findToolItem(TOOLBAR_ITEM_SHOW_HIDDEN);
        if (toolItem != null) {
            if (this.showingHiddenFiles) {
                toolItem.setImage(GuiResource.getInstance().getImageShow());
            } else {
                toolItem.setImage(GuiResource.getInstance().getImageHide());
            }
        }
        this.refresh();
    }

    private void setTreeItemData(TreeItem treeItem, String path, String name, IHopFileType fileType, int depth, boolean folder, boolean loaded) {
        treeItem.setData((Object)new TreeItemFolder(treeItem, path, name, fileType, depth, folder, loaded));
    }

    private void setItemImage(TreeItem treeItem, IHopFileType fileType) {
        Image image = this.typeImageMap.get(fileType.getName());
        if (image != null) {
            treeItem.setImage(image);
        }
    }

    public Image getFileTypeImage(IHopFileType fileType) {
        return this.typeImageMap.get(fileType.getName());
    }

    public IHopFileType getFileType(String path) throws HopException {
        for (IHopFileType hopFileType : this.fileTypes) {
            if (!hopFileType.isHandledBy(path, false)) continue;
            return hopFileType;
        }
        return new EmptyFileType();
    }

    private void refreshFolder(TreeItem item, String path, int depth) {
        try {
            for (TreeItem child : item.getItems()) {
                child.dispose();
            }
            FileObject fileObject = HopVfs.getFileObject((String)path);
            FileObject[] children = fileObject.getChildren();
            Arrays.sort(children, Comparator.comparing(Object::toString));
            for (boolean folder : new boolean[]{true, false}) {
                for (FileObject child : children) {
                    boolean isFiltering;
                    String childName = child.getName().getBaseName();
                    String metadataFolder = this.hopGui.getVariables().getVariable("HOP_METADATA_FOLDER");
                    if (!this.showingHiddenFiles && (child.isHidden() || childName.startsWith(".") || child.toString().contains(metadataFolder)) || child.isFolder() != folder || !Utils.isEmpty((CharSequence)this.filterText) && !childName.toLowerCase().contains(this.filterText) && !this.hasMatchingDescendant(child)) continue;
                    String childPath = HopVfs.getFilename((FileObject)child);
                    IHopFileType fileType = this.getFileType(childPath);
                    TreeItem childItem = new TreeItem(item, 0);
                    childItem.setText(childName);
                    this.setItemImage(childItem, fileType);
                    this.callPaintListeners(this.tree, childItem, childPath, childName);
                    this.setTreeItemData(childItem, childPath, childName, fileType, depth, folder, true);
                    if (!child.isFolder()) continue;
                    String maxDepthString = ExplorerPerspectiveConfigSingleton.getConfig().getLazyLoadingDepth();
                    int maxDepth = Const.toInt((String)this.hopGui.getVariables().resolve(maxDepthString), (int)0);
                    boolean bl = isFiltering = !Utils.isEmpty((CharSequence)this.filterText);
                    if (depth + 1 <= maxDepth || isFiltering) {
                        childItem.setData((Object)new TreeItemFolder(childItem, childPath, childName, fileType, depth, folder, true));
                        this.refreshFolder(childItem, childPath, depth + 1);
                        if (!isFiltering || childItem.getItemCount() <= 0) continue;
                        childItem.setExpanded(true);
                        TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, childItem, true);
                        continue;
                    }
                    childItem.setData((Object)new TreeItemFolder(childItem, childPath, childName, fileType, depth, folder, false));
                    new TreeItem(childItem, 0);
                    childItem.setExpanded(false);
                    TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, childItem, false);
                }
            }
        }
        catch (Exception e) {
            TreeItem treeItem = new TreeItem(item, 0);
            treeItem.setText("!!Error refreshing folder!!");
            this.hopGui.getLog().logError("Error refresh folder '" + path + "'", (Throwable)e);
        }
    }

    private void callPaintListeners(Tree tree, TreeItem treeItem, String path, String name) {
        for (IExplorerFilePaintListener filePaintListener : this.filePaintListeners) {
            filePaintListener.filePainted(tree, treeItem, path, name);
        }
    }

    private void saveTreeState() {
        this.treeStateBeforeFilter = new HashMap<String, Boolean>();
        if (this.tree != null && !this.tree.isDisposed()) {
            for (TreeItem item : this.tree.getItems()) {
                this.saveTreeItemState(item);
            }
        }
    }

    private void saveTreeItemState(TreeItem item) {
        if (item == null || item.isDisposed()) {
            return;
        }
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.path != null) {
            this.treeStateBeforeFilter.put(tif.path, item.getExpanded());
        }
        for (TreeItem child : item.getItems()) {
            this.saveTreeItemState(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTreeState() {
        if (this.treeStateBeforeFilter != null && this.tree != null && !this.tree.isDisposed()) {
            this.tree.setRedraw(false);
            try {
                for (TreeItem item : this.tree.getItems()) {
                    this.restoreTreeItemState(item);
                }
            }
            finally {
                this.tree.setRedraw(true);
                this.treeStateBeforeFilter = null;
            }
        }
    }

    private void restoreTreeItemState(TreeItem item) {
        if (item == null || item.isDisposed()) {
            return;
        }
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.path != null && this.treeStateBeforeFilter.containsKey(tif.path)) {
            TreeItem firstChild;
            boolean wasExpanded = this.treeStateBeforeFilter.get(tif.path);
            if (wasExpanded && !tif.loaded && item.getItemCount() == 1 && (firstChild = item.getItem(0)).getData() == null) {
                this.refreshFolder(item, tif.path, tif.depth + 1);
                tif.loaded = true;
            }
            item.setExpanded(wasExpanded);
            TreeMemory.getInstance().storeExpanded(FILE_EXPLORER_TREE, item, wasExpanded);
        }
        for (TreeItem child : item.getItems()) {
            this.restoreTreeItemState(child);
        }
    }

    private boolean hasMatchingDescendant(FileObject folder) {
        return this.hasMatchingDescendant(folder, 0, 10);
    }

    private boolean hasMatchingDescendant(FileObject folder, int currentDepth, int maxDepth) {
        if (Utils.isEmpty((CharSequence)this.filterText)) {
            return true;
        }
        if (currentDepth >= maxDepth) {
            return false;
        }
        try {
            FileObject[] children;
            if (!folder.isFolder()) {
                return false;
            }
            for (FileObject child : children = folder.getChildren()) {
                String childName = child.getName().getBaseName();
                if (!this.showingHiddenFiles && (child.isHidden() || childName.startsWith("."))) continue;
                if (childName.toLowerCase().contains(this.filterText)) {
                    return true;
                }
                if (!child.isFolder() || !this.hasMatchingDescendant(child, currentDepth + 1, maxDepth)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void updateTabItem(IHopFileTypeHandler fileTypeHandler) {
        CTabItem tabItem;
        TabItemHandler tabItemHandler = this.getTabItemHandler(fileTypeHandler);
        if (tabItemHandler != null && !(tabItem = tabItemHandler.getTabItem()).isDisposed()) {
            String displayName = this.getTabDisplayName(fileTypeHandler);
            tabItem.setText(Const.NVL((String)displayName, (String)"<>"));
            tabItem.setToolTipText(Const.NVL((String)fileTypeHandler.getFilename(), (String)""));
            Font font = fileTypeHandler.hasChanged() ? GuiResource.getInstance().getFontBold() : this.tabFolder.getFont();
            tabItem.setFont(font);
        }
    }

    private String getTabDisplayName(IHopFileTypeHandler fileTypeHandler) {
        String name = fileTypeHandler.getName();
        String filename = fileTypeHandler.getFilename();
        if (filename != null && (filename.toLowerCase().startsWith("http://") || filename.toLowerCase().startsWith("https://")) && (name == null || name.equals(filename) || name.length() > 30)) {
            return this.extractTitleFromUrl(filename);
        }
        return name;
    }

    private String extractTitleFromUrl(String url) {
        try {
            String path = url;
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf("?"));
            }
            if (path.contains("#")) {
                path = path.substring(0, path.indexOf("#"));
            }
            String[] parts = path.split("/");
            String lastPart = "";
            for (int i = parts.length - 1; i >= 0; --i) {
                if (parts[i].isEmpty() || parts[i].equals("manual") || parts[i].equals("latest")) continue;
                lastPart = parts[i];
                break;
            }
            if (lastPart.endsWith(".html") || lastPart.endsWith(".htm")) {
                lastPart = lastPart.substring(0, lastPart.lastIndexOf("."));
            }
            Object title = lastPart.replaceAll("[-_]", " ");
            title = ((String)title).replaceAll("([a-z])([A-Z])", "$1 $2");
            String[] words = ((String)title).split("\\s+");
            StringBuilder result = new StringBuilder();
            for (String word : words) {
                if (word.isEmpty()) continue;
                if (!result.isEmpty()) {
                    result.append(" ");
                }
                result.append(word.substring(0, 1).toUpperCase());
                if (word.length() <= 1) continue;
                result.append(word.substring(1).toLowerCase());
            }
            title = result.toString();
            if (!((String)title).isEmpty() && ((String)title).length() <= 30) {
                return title;
            }
            if (((String)title).length() > 30) {
                title = ((String)title).substring(0, 27) + "...";
            }
            if (((String)title).isEmpty() || ((String)title).length() < 5) {
                int domainEnd = path.indexOf("/", 8);
                if (domainEnd > 0 && domainEnd < path.length() - 1) {
                    String domain = path.substring(0, domainEnd);
                    Object pathPart = path.substring(domainEnd);
                    if (((String)pathPart).length() > 20) {
                        pathPart = "..." + ((String)pathPart).substring(((String)pathPart).length() - 17);
                    }
                    title = domain + (String)pathPart;
                } else {
                    title = path;
                }
                if (((String)title).length() > 30) {
                    title = ((String)title).substring(0, 27) + "...";
                }
            }
            return title;
        }
        catch (Exception e) {
            if (url.length() > 30) {
                return url.substring(0, 27) + "...";
            }
            return url;
        }
    }

    public void updateTreeItem(IHopFileTypeHandler fileTypeHandler) {
        String filename = fileTypeHandler.getFilename();
        if (filename != null) {
            try {
                filename = HopVfs.normalize((String)filename);
            }
            catch (HopFileException e) {
                this.hopGui.getLog().logError("Error getting VFS fileObject ''{0}''", new Object[]{filename});
            }
            TreeItem item = this.findTreeItem(filename);
            if (item != null) {
                for (IExplorerRefreshListener listener : this.refreshListeners) {
                    listener.beforeRefresh();
                }
                this.callPaintListeners(this.tree, item, filename, fileTypeHandler.getName());
            }
        }
    }

    private TreeItem findTreeItem(String filename) {
        for (TreeItem item : this.tree.getItems()) {
            TreeItem found = this.findTreeItem(item, filename);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private TreeItem findTreeItem(TreeItem item, String filename) {
        TreeItemFolder tif = (TreeItemFolder)item.getData();
        if (tif != null && tif.path.equals(filename)) {
            return tif.treeItem;
        }
        for (TreeItem child : item.getItems()) {
            TreeItem found = this.findTreeItem(child, filename);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void updateSelection() {
        TreeItemFolder tif = null;
        if (this.tree.getSelectionCount() > 0) {
            TreeItem selectedItem = this.tree.getSelection()[0];
            tif = (TreeItemFolder)selectedItem.getData();
            if (tif == null) {
                return;
            }
            HopGuiSelectionTracker.getInstance().setLastSelectionType(HopGuiSelectionTracker.SelectionType.FILE_EXPLORER);
        }
        boolean isFolderSelected = tif != null && tif.fileType instanceof FolderFileType;
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_CREATE_FOLDER, isFolderSelected);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_OPEN, tif != null);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DELETE, tif != null);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_RENAME, tif != null);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_CREATE_FOLDER, isFolderSelected);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_OPEN, tif != null);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_DELETE, tif != null);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_RENAME, tif != null);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_COPY_NAME, tif != null);
        this.menuWidgets.enableMenuItem(CONTEXT_MENU_COPY_PATH, tif != null);
        for (IExplorerSelectionListener listener : this.selectionListeners) {
            listener.fileSelected();
        }
    }

    @Override
    public boolean remove(IHopFileTypeHandler fileTypeHandler) {
        if (fileTypeHandler.isCloseable()) {
            TabItemHandler item = this.getTabItemHandler(fileTypeHandler);
            this.removeTabItem(item);
            return true;
        }
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        return this.items;
    }

    @Override
    public void navigateToPreviousFile() {
        if (this.hasNavigationPreviousFile()) {
            int index = this.tabFolder.getSelectionIndex() - 1;
            if (index < 0) {
                index = this.tabFolder.getItemCount() - 1;
            }
            this.tabFolder.setSelection(index);
            this.updateGui();
        }
    }

    @Override
    public void navigateToNextFile() {
        if (this.hasNavigationNextFile()) {
            int index = this.tabFolder.getSelectionIndex() + 1;
            if (index >= this.tabFolder.getItemCount()) {
                index = 0;
            }
            this.tabFolder.setSelection(index);
            this.updateGui();
        }
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return this.tabFolder.getItemCount() > 1;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return this.tabFolder.getItemCount() > 1;
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    protected Shell getShell() {
        return this.hopGui.getShell();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }

    public void updateGui() {
        if (this.hopGui == null || this.toolBarWidgets == null || this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        IHopFileTypeHandler activeHandler = this.getActiveFileTypeHandler();
        activeHandler.updateGui();
    }

    public void toggleFileExplorerPanel() {
        if (this.sash == null || this.sash.isDisposed()) {
            return;
        }
        boolean bl = this.fileExplorerPanelVisible = !this.fileExplorerPanelVisible;
        if (this.fileExplorerPanelVisible) {
            this.sash.setMaximizedControl(null);
            this.sash.setWeights(new int[]{20, 80});
        } else {
            this.sash.setMaximizedControl((Control)this.tabFolder);
        }
    }

    public boolean isFileExplorerPanelVisible() {
        return this.fileExplorerPanelVisible;
    }

    @Generated
    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }

    @Generated
    public ExplorerFileType getExplorerFileType() {
        return this.explorerFileType;
    }

    @Generated
    public HopPipelineFileType<PipelineMeta> getPipelineFileType() {
        return this.pipelineFileType;
    }

    @Generated
    public HopWorkflowFileType<WorkflowMeta> getWorkflowFileType() {
        return this.workflowFileType;
    }

    @Generated
    public Tree getTree() {
        return this.tree;
    }

    @Generated
    public GuiMenuWidgets getMenuWidgets() {
        return this.menuWidgets;
    }

    @Generated
    public String getRootFolder() {
        return this.rootFolder;
    }

    @Generated
    public String getRootName() {
        return this.rootName;
    }

    @Generated
    public List<IExplorerFilePaintListener> getFilePaintListeners() {
        return this.filePaintListeners;
    }

    @Generated
    public List<IExplorerRootChangedListener> getRootChangedListeners() {
        return this.rootChangedListeners;
    }

    @Generated
    public List<IExplorerRefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    @Generated
    public List<IExplorerSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    public static class DetermineRootFolderExtension {
        public HopGui hopGui;
        public String rootFolder;
        public String rootName;

        public DetermineRootFolderExtension(HopGui hopGui, String rootFolder, String rootName) {
            this.hopGui = hopGui;
            this.rootFolder = rootFolder;
            this.rootName = rootName;
        }
    }

    private static class TreeItemFolder {
        public TreeItem treeItem;
        public String path;
        public String name;
        public IHopFileType fileType;
        public int depth;
        public boolean folder;
        public boolean loaded;

        public TreeItemFolder(TreeItem treeItem, String path, String name, IHopFileType fileType, int depth, boolean folder, boolean loaded) {
            this.treeItem = treeItem;
            this.path = path;
            this.name = name;
            this.fileType = fileType;
            this.depth = depth;
            this.folder = folder;
            this.loaded = loaded;
        }
    }
}

