/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.AbstractValueMap;

class IntegerToLongValueMap
extends AbstractValueMap {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final long UPPER_LIMIT_ = 0x100000000L;

    IntegerToLongValueMap() {
    }

    @Override
    public Object ptol(Object physicalValue) {
        if (physicalValue == null) {
            throw new NullPointerException("physicalValue");
        }
        if (!(physicalValue instanceof Integer)) {
            throw new ExtendedIllegalArgumentException("physicalValue", 2);
        }
        int intValue = (Integer)physicalValue;
        if (intValue >= 0) {
            return (long)intValue;
        }
        return 0x100000000L + (long)intValue;
    }
}

