/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

abstract class AS400JDBCOutputStream
extends OutputStream {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long position_;

    AS400JDBCOutputStream(long positionToStartWriting) {
        this.position_ = positionToStartWriting;
    }

    @Override
    public void close() {
        this.closed_ = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void write(byte[] byteArray) throws IOException {
        if (byteArray == null) {
            throw new NullPointerException("byteArray");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(byteArray, 0, byteArray.length);
    }

    @Override
    public synchronized void write(byte[] byteArray, int off, int len) throws IOException {
        if (byteArray == null) {
            throw new NullPointerException("byteArray");
        }
        if (off < 0 || off > len) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (len < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            int numWritten = this.doWrite(this.position_, byteArray, off, len);
            if (numWritten != len) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Unable to write requested number of bytes: " + numWritten + " != " + len);
                }
                this.closed_ = true;
                throw new IOException();
            }
            this.position_ += (long)len;
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(this, "Exception caught", e);
            }
            this.closed_ = true;
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            int numWritten = this.doWrite(this.position_, (byte)b);
            if (numWritten != 1) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Unable to write requested number of bytes: " + numWritten + " != 1");
                }
                this.closed_ = true;
                throw new IOException();
            }
            ++this.position_;
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(this, "Exception caught", e);
            }
            this.closed_ = true;
            throw new IOException(e);
        }
    }

    abstract int doWrite(long var1, byte[] var3, int var4, int var5) throws SQLException;

    abstract int doWrite(long var1, byte var3) throws SQLException;
}

