/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.ReplicatingInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;

@PublicEvolving
public final class ReplicatingInputFormat<OT, S extends InputSplit>
extends RichInputFormat<OT, S> {
    private static final long serialVersionUID = 1L;
    private InputFormat<OT, S> replicatedIF;

    public ReplicatingInputFormat(InputFormat<OT, S> wrappedIF) {
        this.replicatedIF = wrappedIF;
    }

    public InputFormat<OT, S> getReplicatedInputFormat() {
        return this.replicatedIF;
    }

    @Override
    public void configure(Configuration parameters) {
        this.replicatedIF.configure(parameters);
    }

    @Override
    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return this.replicatedIF.getStatistics(cachedStatistics);
    }

    @Override
    public S[] createInputSplits(int minNumSplits) throws IOException {
        return this.replicatedIF.createInputSplits(minNumSplits);
    }

    @Override
    public InputSplitAssigner getInputSplitAssigner(S[] inputSplits) {
        return new ReplicatingInputSplitAssigner((InputSplit[])inputSplits);
    }

    @Override
    public void open(S split) throws IOException {
        this.replicatedIF.open(split);
    }

    @Override
    public boolean reachedEnd() throws IOException {
        return this.replicatedIF.reachedEnd();
    }

    @Override
    public OT nextRecord(OT reuse) throws IOException {
        return this.replicatedIF.nextRecord(reuse);
    }

    @Override
    public void close() throws IOException {
        this.replicatedIF.close();
    }

    @Override
    public void setRuntimeContext(RuntimeContext context) {
        if (this.replicatedIF instanceof RichInputFormat) {
            ((RichInputFormat)this.replicatedIF).setRuntimeContext(context);
        }
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        if (this.replicatedIF instanceof RichInputFormat) {
            return ((RichInputFormat)this.replicatedIF).getRuntimeContext();
        }
        throw new RuntimeException("The underlying input format to this ReplicatingInputFormat isn't context aware");
    }

    @Override
    public void openInputFormat() throws IOException {
        if (this.replicatedIF instanceof RichInputFormat) {
            ((RichInputFormat)this.replicatedIF).openInputFormat();
        }
    }

    @Override
    public void closeInputFormat() throws IOException {
        if (this.replicatedIF instanceof RichInputFormat) {
            ((RichInputFormat)this.replicatedIF).closeInputFormat();
        }
    }
}

