/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.io.Serializable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.util.SerializableThrowable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=SerializableCoder.class)
public final class SuccessOrFailure
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized boolean isSuccess;
    private final  @Nullable @UnknownKeyFor @Initialized PAssert.PAssertionSite site;
    private final @Nullable @UnknownKeyFor @Initialized SerializableThrowable throwable;

    private SuccessOrFailure(@UnknownKeyFor @NonNull @Initialized boolean isSuccess,  @Nullable @UnknownKeyFor @Initialized PAssert.PAssertionSite site, @Nullable @UnknownKeyFor @Initialized Throwable throwable) {
        this.isSuccess = isSuccess;
        this.site = site;
        this.throwable = new SerializableThrowable(throwable);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSuccess() {
        return this.isSuccess;
    }

    public @Nullable @UnknownKeyFor @Initialized AssertionError assertionError() {
        return this.site == null ? null : this.site.wrap(this.throwable.getThrowable());
    }

    public static @UnknownKeyFor @NonNull @Initialized SuccessOrFailure success() {
        return new SuccessOrFailure(true, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized SuccessOrFailure failure( @Nullable @UnknownKeyFor @Initialized PAssert.PAssertionSite site, @Nullable @UnknownKeyFor @Initialized Throwable t) {
        return new SuccessOrFailure(false, site, t);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isSuccess", this.isSuccess()).addValue((Object)this.throwable).omitNullValues().toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuccessOrFailure that = (SuccessOrFailure)o;
        return this.isSuccess == that.isSuccess && Objects.equal((Object)this.site, (Object)that.site) && Objects.equal((Object)this.throwable, (Object)that.throwable);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isSuccess, this.site, this.throwable});
    }
}

