/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.util.FatalExitExceptionHandler;

public class Runnables {
    public static void assertNoException(Runnable runnable) {
        Runnables.withUncaughtExceptionHandler(runnable, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE).run();
    }

    public static Runnable withUncaughtExceptionHandler(Runnable runnable, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
            }
        };
    }
}

